#include "bookinfowindow.h"
#include "ui_bookinfowindow.h"

BookInfoWindow::BookInfoWindow(QWidget *parent, Book* book) :
    QDialog(parent),
    ui(new Ui::BookInfoWindow)
{
    ui->setupUi(this);

    m_Book = book;

    ui->lblTitle->setText(m_Book->Title);
    ui->lblAuthors->setText(m_Book->Authors);
    ui->lblNumber->setText(QString::number(m_Book->Number));
    ui->lblVersion->setText(QString("%1.%2").arg(m_Book->Version).arg(m_Book->Revision));
    ui->lblSections->setText(QString::number(m_Book->Sections.count() - 1));
    ui->lblScriptedBy->setText(m_Book->ScriptedBy);

    connect(ui->pbnOk, SIGNAL(clicked()), this, SLOT(accept()));
}

BookInfoWindow::~BookInfoWindow()
{
    delete ui;
}
