#include "cartwheelwindow.h"
#include "ui_cartwheelwindow.h"
#include "commonstatic.h"
#include <QCloseEvent>

CartwheelWindow::CartwheelWindow(QWidget *parent, Player* player) :
    QMainWindow(parent),
    ui(new Ui::CartwheelWindow)
{
    ui->setupUi(this);
#ifndef Q_WS_MAEMO_5
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    CommonStatic::CenterWindow(this);
#endif
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    m_CanClose = true;
    m_Loop = NULL;
    m_Won = 0;
    m_Value = 0;
    m_Player = player;

    m_Bet = 1;
    ui->lblBet->setText(QString::number(m_Bet));

    m_RandomPicker = new RandomNumberPicker(this, ui->lblDice, false);
    connect(m_RandomPicker, SIGNAL(Random(int)), SLOT(RandomSlot(int)));

    connect(ui->pbnBetMinus, SIGNAL(clicked()), this, SLOT(BetMinusSlot()));
    connect(ui->pbnBetPlus, SIGNAL(clicked()), this, SLOT(BetPlusSlot()));
    connect(ui->pbnMinus, SIGNAL(clicked()), this, SLOT(MinusSlot()));
    connect(ui->pbnPlus, SIGNAL(clicked()), this, SLOT(PlusSlot()));
    connect(ui->pbnLeave, SIGNAL(clicked()), this, SLOT(close()));
    connect(ui->pbnPlay, SIGNAL(clicked()), this, SLOT(PlaySlot()));

    UpdateData();
}

CartwheelWindow::~CartwheelWindow()
{
    delete ui;
}

void CartwheelWindow::exec()
{
    m_Loop = new QEventLoop(this);
    show();
    m_Loop->exec();
}

void CartwheelWindow::closeEvent(QCloseEvent* event)
{
    if (m_CanClose){
        if (m_Loop)
            m_Loop->quit();
        event->accept();
    }else{
        event->ignore();
    }
}

void CartwheelWindow::RandomSlot(int random)
{
    Evaluate(random);
    UpdateData();
    EnableButtons(true);
}

void CartwheelWindow::UpdateData()
{
    ui->lblGoldCrowns->setText(QString::number(m_Player->GetGoldCrowns()));
}

void CartwheelWindow::EnableButtons(bool enable)
{
    ui->pbnBetMinus->setEnabled(enable);
    ui->pbnBetPlus->setEnabled(enable);
    ui->pbnLeave->setEnabled(enable);
    ui->pbnMinus->setEnabled(enable);
    ui->pbnPlus->setEnabled(enable);

    if (m_Won == 40 || m_Player->GetGoldCrowns() == 0)
        ui->pbnPlay->setEnabled(false);
    else
        ui->pbnPlay->setEnabled(enable);
}

void CartwheelWindow::Evaluate(int random)
{
    int won = 0;
    int lost = 0;

    if (random == m_Value)
        won = m_Bet * 8;
    else if (m_Value == random - 1 || m_Value == random + 1 ||
             (m_Value == 1 && random == 10) ||
             (m_Value == 0 && random == 9))
        won = m_Bet * 5;

    if (m_Won + won > 40)
        won = 40 - m_Won;

    m_Won += won - lost;
    if (!won)
        lost = m_Bet;

    if (lost)
        ui->lblMessage->setText(QString("%1! You lost %2 Gold Crown(s)").arg(random).arg(lost));
    else
        ui->lblMessage->setText(QString("%1! You won %2 Gold Crowns").arg(random).arg(won));

    m_Player->SetGoldCrowns(m_Player->GetGoldCrowns() + won - lost);
    m_CanClose = true;
}

void CartwheelWindow::BetMinusSlot()
{
    if (m_Bet > 1){
        m_Bet--;
        ui->lblBet->setText(QString::number(m_Bet));
    }
}

void CartwheelWindow::BetPlusSlot()
{
    if (m_Bet < m_Player->GoldCrowns){
        m_Bet++;
        ui->lblBet->setText(QString::number(m_Bet));
    }
}

void CartwheelWindow::MinusSlot()
{
    if (m_Value > 0)
        m_Value--;
    else
        m_Value = 9;

    ui->lblValue->setText(QString::number(m_Value));
}

void CartwheelWindow::PlusSlot()
{
    if (m_Value < 9)
        m_Value++;
    else
        m_Value = 0;
    ui->lblValue->setText(QString::number(m_Value));

}

void CartwheelWindow::PlaySlot(){
    m_CanClose = false;
    EnableButtons(false);
    ui->lblMessage->clear();

    m_RandomPicker->GetRandomNumber(NULL);
}
