#ifndef RANDOMNUMBERPICKER_H
#define RANDOMNUMBERPICKER_H

#include <QObject>
#include <QLabel>
#include <QTimer>

class RandomNumberPicker : public QObject
{
    Q_OBJECT
public:
    explicit RandomNumberPicker(QObject *parent = 0, QLabel* label=0, bool centerOnParent=true, int min=0, int max=9, int bonus=0);

    void GetRandomNumber(QWidget* labelParent=0, int* result=0);
    void SetBonus(int value) { m_Bonus = value; }
    int GetLastRandomNumber() { return m_DiceValue; }

private:
    bool m_Working;
    bool m_CenterOnParent;
    int m_Bonus;
    int m_Min;
    int m_Max;
    QLabel* m_Label;
    int m_DiceProgress;
    QTimer* m_DiceTimer;
    int m_DiceValue;

signals:
    // Signal emitted with the random number + bonus value
    void Random(int);

private slots:
    void DiceTimerSlot();

};

#endif // RANDOMNUMBERPICKER_H
