#include "fightwindow.h"
#include "ui_fightwindow.h"
#include <QMessageBox>
#include "commonstatic.h"
#include "combatskillwindow.h"

FightWindow::FightWindow(QWidget *parent, Player* player, Enemy* enemy, bool canEvade, QScriptEngine* engine) :
    DialogWindow(parent),
    ui(new Ui::FightWindow)
{
    ui->setupUi(this);
#ifndef Q_WS_MAEMO_5
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    CommonStatic::CenterWindow(this);
#endif
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    setAttribute(Qt::WA_Maemo5StackedWindow);

    QPalette secondaryPalette = CommonStatic::GetSecondaryPalette();
    ui->lblLoneWolf->setPalette(secondaryPalette);
    ui->lblEnemy->setPalette(secondaryPalette);
#endif

    ui->lblCombatSkillD->setText("<a href=\"#\">Combat Skill:</a>");
    connect(ui->lblCombatSkillD, SIGNAL(linkActivated(QString)), this, SLOT(CombatSkillLinkSlot(QString)));

    SetCanClose(false);
    m_BookWindow = NULL;
    m_UpdatingData = false;
    m_PlayerPointsLost = 0;
    m_EnemyPointsLost = 0;
    m_Round = 0;
    m_SurpriseRound = 0;
    m_Engine = engine;
    connect(ui->pbnFight, SIGNAL(clicked()), this, SLOT(AttackSlot()));
    connect(ui->pbnEvade, SIGNAL(clicked()), this, SLOT(EvadeSlot()));
    connect(ui->pbnClose, SIGNAL(clicked()), this, SLOT(Close()));
    connect(ui->cmbDiscipline, SIGNAL(currentIndexChanged(int)), this, SLOT(DisciplineChangedSlot(int)));

    m_AttackMultiplier = 1;
    m_EnemyAttackMultiplier = 1;
    m_AttackBonus = 0;
    m_RandomBonus = 0;
    m_CanEvade = canEvade;
    m_Evaded = false;
    m_Player = player;
    m_Enemy = enemy;

    m_RandomPicker = new RandomNumberPicker(this, ui->lblDice, false);
    connect(m_RandomPicker, SIGNAL(Random(int)), SLOT(RandomSlot(int)));

    m_CombatResult[-11] = "0;k|0;k|0;8|0;8|1;7|2;6|3;5|4;4|5;3|6;0";
    m_CombatResult[-10] = "0;k|0;8|0;7|1;7|2;6|3;6|4;5|5;4|6;3|7;0";
    m_CombatResult[-9] = "0;k|0;8|0;7|1;7|2;6|3;6|4;5|5;4|6;3|7;0";
    m_CombatResult[-8] = "0;8|0;7|1;6|2;6|3;5|4;5|5;4|6;3|7;2|8;0";
    m_CombatResult[-7] = "0;8|0;7|1;6|2;6|3;5|4;5|5;4|6;3|7;2|8;0";
    m_CombatResult[-6] = "0;6|1;6|2;5|3;5|4;4|5;4|6;3|7;2|8;0|9;0";
    m_CombatResult[-5] = "0;6|1;6|2;5|3;5|4;4|5;4|6;3|7;2|8;0|9;0";
    m_CombatResult[-4] = "1;6|2;5|3;5|4;4|5;4|6;3|7;2|8;1|9;0|10;0";
    m_CombatResult[-3] = "1;6|2;5|3;5|4;4|5;4|6;3|7;2|8;1|9;0|10;0";
    m_CombatResult[-2] = "2;5|3;5|4;4|5;4|6;3|7;2|8;2|9;1|10;0|11;0";
    m_CombatResult[-1] = "2;5|3;5|4;4|5;4|6;3|7;2|8;2|9;1|10;0|11;0";
    m_CombatResult[0] = "3;5|4;4|5;4|6;3|7;2|8;2|9;1|10;0|11;0|12;0";
    m_CombatResult[1] = "4;5|5;4|6;3|7;3|8;2|9;2|10;1|11;0|12;0|14;0";
    m_CombatResult[2] = "4;5|5;4|6;3|7;3|8;2|9;2|10;1|11;0|12;0|14;0";
    m_CombatResult[3] = "5;4|6;3|7;3|8;2|9;2|10;2|11;1|12;0|14;0|16;0";
    m_CombatResult[4] = "5;4|6;3|7;3|8;2|9;2|10;2|11;1|12;0|14;0|16;0";
    m_CombatResult[5] = "6;4|7;3|8;3|9;2|10;2|11;1|12;0|14;0|16;0|18;0";
    m_CombatResult[6] = "6;4|7;3|8;3|9;2|10;2|11;1|12;0|14;0|16;0|18;0";
    m_CombatResult[7] = "7;4|8;3|9;2|10;2|11;2|12;1|14;0|16;0|18;0|k;0";
    m_CombatResult[8] = "7;4|8;3|9;2|10;2|11;2|12;1|14;0|16;0|18;0|k;0";
    m_CombatResult[9] = "8;3|9;3|10;2|11;2|12;2|14;1|16;0|18;0|k;0|k;0";
    m_CombatResult[10] = "8;3|9;3|10;2|11;2|12;2|14;1|16;0|18;0|k;0|k;0";
    m_CombatResult[11] = "9;3|10;2|11;2|12;2|14;1|16;1|18;0|k;0|k;0|k;0";


    if(!m_Enemy->EnterScript.isEmpty())
        ExecuteScript("EnterScript", m_Enemy->EnterScript);
    UpdateData();
}

FightWindow::~FightWindow()
{
    delete ui;
}

void FightWindow::UpdateData()
{
    m_UpdatingData = true;
    if (m_Player->HasDiscipline("Psi-surge")){
        ui->lblDiscipline->setVisible(true);
        ui->cmbDiscipline->setVisible(true);

        QStringList items;        
        ui->cmbDiscipline->clear();        
        if (!m_Enemy->DisciplineImmunities.contains("Mindblast"))
            items.append("Mindblast");
        if (!m_Enemy->DisciplineImmunities.contains("Psi-surge"))
            items.append("Psi-surge");

        if (items.count() == 0){
            ui->cmbDiscipline->addItem("None");
            ui->cmbDiscipline->setCurrentIndex(0);
            ui->cmbDiscipline->setEnabled(false);
        }else{
            items.insert(0, "None");
            KaiDiscipline* mindBlast = m_Player->GetDiscipline("Mindblast");
            KaiDiscipline* psiSurge = m_Player->GetDiscipline("Psi-surge");
            if (psiSurge->GetIsActive() && !items.contains("Psi-surge"))
                psiSurge->SetIsActive(false);
            if (mindBlast->GetIsActive() && !items.contains("Mindblast"))
                mindBlast->SetIsActive(false);

            if (psiSurge->GetIsActive() && m_Player->Endurance <= 6){
                psiSurge->SetIsActive(false);
                ui->cmbDiscipline->setEnabled(false);
            }

            ui->cmbDiscipline->addItems(items);
            if (psiSurge->GetIsActive()){
                ui->cmbDiscipline->setCurrentIndex(items.indexOf("Psi-surge"));
                mindBlast->SetIsActive(false);
            }else if (mindBlast->GetIsActive()){
                ui->cmbDiscipline->setCurrentIndex(items.indexOf("Mindblast"));
                psiSurge->SetIsActive(false);
            }else if (items.contains("None")){
                ui->cmbDiscipline->setCurrentIndex(items.indexOf("None"));
                psiSurge->SetIsActive(false);
                mindBlast->SetIsActive(false);
            }
        }
    }else{
        ui->lblDiscipline->setVisible(false);
        ui->cmbDiscipline->setVisible(false);
    }

    ui->lblRound->setText(QString("Round %1").arg(m_Round + 1));
    ui->lblCombatSkill->setText(QString::number(m_Player->GetCombatSkill(m_Enemy)));
    ui->lblEndurance->setText(QString::number(m_Player->Endurance));

    ui->lblEnemy->setText(m_Enemy->Name);
    ui->lblEnemySkill->setText(QString::number(m_Enemy->CombatSkill));
    ui->lblEnemyEndurance->setText(QString::number(m_Enemy->Endurance));
    if (m_Enemy->DisciplineImmunities.count() > 0){
        ui->lblImmuneTo->setText(m_Enemy->DisciplineImmunities.join(", "));
    }else{
        ui->lblImmuneToLabel->setVisible(false);
        ui->lblImmuneTo->setVisible(false);
        ui->lblPlaceholder->setVisible(false);
    }

    ui->pbnClose->setVisible(false);
    ui->pbnEvade->setVisible(m_CanEvade);
    ui->pbnFight->setVisible(true);

    if (m_Enemy->IsDead() || m_Evaded || m_Player->IsDead()){
        ui->pbnClose->setVisible(true);
        ui->pbnEvade->setVisible(false);
        ui->pbnFight->setVisible(false);
    }
    m_UpdatingData = false;
}

void FightWindow::Close()
{
    if(!m_Enemy->ExitScript.isEmpty())
        ExecuteScript("ExitScript", m_Enemy->ExitScript);
    SetCanClose(true);
    close();
}

void FightWindow::AttackSlot()
{
    ui->lblMessage->clear();
    ui->pbnFight->setEnabled(false);
    ui->pbnEvade->setEnabled(false);

    m_RandomPicker->SetBonus(m_RandomBonus);
    m_RandomPicker->GetRandomNumber(NULL);
}

void FightWindow::EvadeSlot()
{
    m_Evaded = true;
    ui->pbnFight->setEnabled(false);
    ui->pbnEvade->setEnabled(false);

    m_RandomPicker->SetBonus(m_RandomBonus);
    m_RandomPicker->GetRandomNumber(NULL);
}

void FightWindow::RandomSlot(int random)
{
    Evaluate(random);
    if (!m_Enemy->IsDead() && !m_Evaded && !m_Player->IsDead()){
        if (!m_Enemy->RoundScript.isNull())
            ExecuteScript("RoundScript", m_Enemy->RoundScript);
        m_Round++;
    }
    UpdateData();
    ui->pbnFight->setEnabled(true);
    ui->pbnEvade->setEnabled(true);
}

void FightWindow::Evaluate(int number)
{
    if (number == 0 || number > 10)
        number = 10;

    int ratio = m_Player->GetCombatSkill(m_Enemy) - m_Enemy->CombatSkill;

    if (ratio > 11)
        ratio = 11;
    else if (ratio < -11)
        ratio = -11;

    QString values = m_CombatResult[ratio];
    QStringList ele = values.split("|");
    QStringList subele = ele.at(number - 1).split(";");

    QString message;
    bool enemyDamage = false;
    bool playerDamage = false;
    m_EnemyDamage = 0;
    m_PlayerDamage = 0;
    if (!m_Evaded){
        enemyDamage = true;
        if (subele.at(0) == "k"){
            m_EnemyDamage = m_Enemy->Endurance;
        }else{
            m_EnemyDamage = subele.at(0).toInt() * m_AttackMultiplier + m_AttackBonus;
            if (m_Enemy->WoundedBy.count() > 0){
                bool canHit = false;
                foreach(QString w, m_Enemy->WoundedBy){
                    if (m_Player->IsEquipped(w)){
                        canHit = true;
                        break;
                    }
                }
                if (!canHit)
                    m_EnemyDamage = 0;
            }

        }
    }

    if (m_Round + 1 > m_SurpriseRound){
        playerDamage = true;
        if (subele.at(1) == "k")
            m_PlayerDamage = m_Player->Endurance;
        else
            m_PlayerDamage = subele.at(1).toInt() * m_EnemyAttackMultiplier;

        if (m_PlayerDamage > m_Player->Endurance)
            m_PlayerDamage = m_Player->Endurance;
    }

    KaiDiscipline* psiSurge = m_Player->GetDiscipline("Psi-surge");
    if (psiSurge && psiSurge->GetIsActive() &&m_Player->GetEndurance() >= 6){
        if (m_Player->GetDisciplineCount() >= 9)
            m_PlayerDamage += 1;
        else
            m_PlayerDamage += 2;
    }

    if(!m_Enemy->DamageScript.isEmpty())
        ExecuteScript("DamageScript", m_Enemy->DamageScript);

    if (enemyDamage){
        m_Enemy->Endurance -= m_EnemyDamage;
        m_EnemyPointsLost += m_EnemyDamage;
        if (m_Enemy->IsDead()){
            message.append(QString("%1 was <b>killed</b>.<br>").arg(m_Enemy->Name));
            ui->lblDice->setText("<font color=\"green\">You won!</font>");
        }else
            message.append(QString("%1 lost <b>%2</b> endurance points.<br>").arg(m_Enemy->Name).arg(m_EnemyDamage));
    }

    if (playerDamage){
        m_Player->Endurance -= m_PlayerDamage;
        m_PlayerPointsLost += m_PlayerDamage;
        if (m_Player->IsDead()){
            message.append("You were <b>killed</b>");
            ui->lblDice->setText("<font color=\"red\">You lost!</font>");
        }else
            message.append(QString("You lost <b>%1</b> endurance points").arg(m_PlayerDamage));
    }

    if (m_Player->Endurance < 0)
        m_Player->Endurance = 0;
    if (m_Enemy->Endurance < 0)
        m_Enemy->Endurance = 0;

    ui->lblMessage->setText(message);
}

bool FightWindow::ExecuteScript(QString name, QString script)
{
    QScriptValue objectValue = m_Engine->newQObject(m_BookWindow);
    m_Engine->globalObject().setProperty("MainWindow", objectValue);
    objectValue = m_Engine->newQObject(this);
    m_Engine->globalObject().setProperty("Window", objectValue);
    objectValue = m_Engine->newQObject(m_Enemy);
    m_Engine->globalObject().setProperty("Enemy", objectValue);

    m_Engine->evaluate(script);
    if (m_Engine->hasUncaughtException()){
        QStringList backTrace = m_Engine->uncaughtExceptionBacktrace();
        QMessageBox msgBox(this);
        msgBox.setWindowTitle(QString("Error in %1").arg(name));

        msgBox.setIcon(QMessageBox::Warning);
        msgBox.setText(QString("%1\n\nBacktrace:\n%2").arg(m_Engine->uncaughtException().toString()).arg(backTrace.join("\n")));
        msgBox.exec();
        return false;
    }
    return true;
}

void FightWindow::Print(QString message)
{
    ui->lblScriptMessage->setText(message);
}

bool FightWindow::HasEvaded()
{
    return m_Evaded;
}

Enemy* FightWindow::GetEnemy()
{
    return m_Enemy;
}

bool FightWindow::GetCanEvade()
{
   return m_CanEvade;
}

void FightWindow::SetCanEvade(bool value)
{
    m_CanEvade = value;
}

int FightWindow::GetRound()
{
    return m_Round + 1;
}

int FightWindow::GetLastRandomNumber()
{
    return m_RandomPicker->GetLastRandomNumber();
}

int FightWindow::GetLostEndurancePoints()
{
    return m_PlayerPointsLost;
}

int FightWindow::GetRandomNumber()
{
    RandomNumberPicker* rnd = new RandomNumberPicker(this, ui->lblDice, false);

    int res = 0;
    rnd->GetRandomNumber(this, &res);

    delete rnd;
    return res;
}

void FightWindow::MessageBox(QString title, QString message)
{
    CommonStatic::Message(this, title, message);
}

void FightWindow::EndFight()
{
    m_Enemy->SetEndurance(0);
    ui->pbnClose->setVisible(true);
    ui->pbnClose->setEnabled(true);
    ui->pbnEvade->setVisible(false);
    ui->pbnFight->setVisible(false);
}

void FightWindow::DisciplineChangedSlot(int index)
{
    if (!m_UpdatingData){
        QString discipline = ui->cmbDiscipline->itemText(index);
        if (discipline == "None"){
            KaiDiscipline* d = m_Player->GetDiscipline("Mindblast");
            if (d)
                d->SetIsActive(false);
            d = m_Player->GetDiscipline("Psi-surge");
            if (d)
                d->SetIsActive(false);
        }else if (discipline == "Mindblast"){
            KaiDiscipline* d = m_Player->GetDiscipline("Mindblast");
            if (d)
                d->SetIsActive(true);
            d = m_Player->GetDiscipline("Psi-surge");
            if (d)
                d->SetIsActive(false);
        }else if (discipline == "Psi-surge"){
            KaiDiscipline* d = m_Player->GetDiscipline("Mindblast");
            if (d)
                d->SetIsActive(false);
            d = m_Player->GetDiscipline("Psi-surge");
            if (d)
                d->SetIsActive(true);
        }
        UpdateData();
    }
}

void FightWindow::CombatSkillLinkSlot(QString)
{
    CombatSkillWindow* dlg = new CombatSkillWindow(this, m_Player, m_Enemy);
    dlg->exec();
}
