#include "noteswindow.h"
#include "ui_noteswindow.h"

NotesWindow::NotesWindow(QWidget *parent, Player* player) :
    DialogWindow(parent),
    ui(new Ui::NotesWindow)
{
    ui->setupUi(this);

    SetCanClose(true);
    setAttribute(Qt::WA_DeleteOnClose);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    connect(ui->pbnSave, SIGNAL(clicked()), this, SLOT(SaveSlot()));

    m_Player = player;
    ui->txtNotes->setPlainText(m_Player->GetNotes());
}

NotesWindow::~NotesWindow()
{
    delete ui;
}

void NotesWindow::SaveSlot()
{
    m_Player->SetNotes(ui->txtNotes->toPlainText());
    close();
}
