#ifndef FIGHTWINDOW_H
#define FIGHTWINDOW_H

#include <QMainWindow>
#include "bookwindow.h"
#include "randomnumberpicker.h"
#include "controls/dialogwindow.h"
#include "core/player.h"
#include "core/book.h"
#include <QScriptEngine>

namespace Ui {
    class FightWindow;
}

//!  The window used for fights
/*!

*/
class FightWindow : public DialogWindow
{
    Q_OBJECT

public:
    explicit FightWindow(QWidget *parent = 0, Player* player=0, Enemy* enemy=0, bool canEvade=false, QScriptEngine* engine=0);
    ~FightWindow();

    void SetBookWindow(BookWindow* value) { m_BookWindow = value; }

private:
    Ui::FightWindow *ui;

    BookWindow* m_BookWindow;
    bool m_UpdatingData;
    int m_LastRandomNumber;
    RandomNumberPicker* m_RandomPicker;
    int m_PlayerDamage;
    int m_PlayerPointsLost;
    int m_EnemyDamage;
    int m_EnemyPointsLost;
    int m_Round;
    int m_SurpriseRound;
    QScriptEngine* m_Engine;
    bool m_CanEvade;
    bool m_Evaded;
    Player* m_Player;
    Enemy* m_Enemy;
    int m_AttackMultiplier;
    int m_EnemyAttackMultiplier;
    int m_AttackBonus;
    int m_RandomBonus;

    void UpdateData();
    void Evaluate(int number);

    QHash<int, QString> m_CombatResult;
    bool ExecuteScript(QString name, QString script);

private slots:
    void AttackSlot();
    void EvadeSlot();
    void RandomSlot(int);
    void DisciplineChangedSlot(int index);
    void CombatSkillLinkSlot(QString);

public slots:
    /** Print a message on the window */
    void Print(QString message);
    /** Display a message box */
    void MessageBox(QString title, QString message);
    /** Returns true if the player has evaded the fight */
    bool HasEvaded();
    /** Sets if the player has evaded the fight */
    void SetHasEvaded(bool value) { m_Evaded = value; }
    /** Returns the enemy of the fight */
    Enemy* GetEnemy();
    /** Returns true if the player can evade the fight */
    bool GetCanEvade();
    /** Sets if the player can evade the fight */
    void SetCanEvade(bool);
    /** Gets the current round number */
    int GetRound();
    /** Gets the last random number */
    int GetLastRandomNumber();
    /** Gets the player total endurance points lost */
    int GetLostEndurancePoints();
    /** Gets the enemy total endurance points lost */
    int GetEnemyLostEndurancePoints() { return m_EnemyPointsLost; }
    /** Closes the window */
    void Close();
    /** Set the player bonus when picking a random number */
    void SetRandomBonus(int value) { m_RandomBonus = value; }
    /** Set the player attack bonus */
    void SetAttackBonus(int value) { m_AttackBonus = value; }
    /** Set the player attack multiplier */
    void SetAttackMultiplier(int value) { m_AttackMultiplier = value; }
    /** Set the enemy attack multiplier */
    void SetEnemyAttackMultiplier(int value) { m_EnemyAttackMultiplier = value; }
    /** Set the player surprise rounds (don't lose endurance points) */
    void SetSurpriseRounds(int value) { m_SurpriseRound = value; }
    /** Gets a random number */
    int GetRandomNumber();
    /** Ends the current fight */
    void EndFight();
    /** Gets the player damage in this round (to be used in roundscript) */
    int GetPlayerDamage() { return m_PlayerDamage; }
    /** Sets the player damage in this round (to be used in roundscript) */
    void SetPlayerDamage(int value) { m_PlayerDamage = value; }
    /** Gets the enemy damage in this round (to be used in roundscript) */
    int GetEnemyDamage() { return m_EnemyDamage; }
    /** Sets the enemy damage in this round (to be used in roundscript) */
    void SetEnemyDamage(int value) { m_EnemyDamage = value; }
};

#endif // FIGHTWINDOW_H
