#include "chooseitemwindow.h"
#include "ui_chooseitemwindow.h"
#include <QLabel>
#include <QPushButton>

ChooseItemWindow::ChooseItemWindow(QWidget *parent, Player* player, int mode, bool mandatory) :
    DialogWindow(parent),
    ui(new Ui::ChooseItemWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
#else
    ui->lblMessage->setVisible(false);
#endif

    SetCanClose(!mandatory);
    m_Selected = NULL;
    m_Player = player;
    m_Mode = mode;

    switch(mode){
    case ChooseWeapon:
    case ChooseWeaponSpecial:
        setWindowTitle("Select a weapon");
        break;
    case ChooseItem:
    case ChooseItemExceptMeals:
        setWindowTitle("Select a item");
        break;
    case ChooseMeal:
        setWindowTitle("Select a meal");
        break;
    case ChooseSpecialItem:
        setWindowTitle("Select a special item");
        break;
    }

    ui->pbnCancel->setVisible(!mandatory);
    connect(ui->pbnCancel, SIGNAL(clicked()), this, SLOT(CancelSlot()));
    ShowItems();
}

ChooseItemWindow::~ChooseItemWindow()
{
    delete ui;
}

void ChooseItemWindow::SetMessage(QString message)
{
    ui->lblMessage->setText(message);
    ui->lblMessage->setVisible(!message.isEmpty());
}

void ChooseItemWindow::ShowItems()
{
    switch (m_Mode)
    {
    case ChooseMeal:
        ShowMeals();
        break;
    case ChooseItem:
        ShowBackpackItems(false);
        break;
    case ChooseItemExceptMeals:
        ShowBackpackItems(true);
        break;
    case ChooseSpecialItem:
        ShowSpecialItems();
        break;
    case ChooseWeapon:
        ShowWeapons(false);
        break;
    case ChooseWeaponSpecial:
        ShowWeapons(true);
        break;
    default:
        break;
    }
}

void ChooseItemWindow::ShowMeals()
{
    setWindowTitle("Choose a meal to eat");
    int row=0;
    int index = 0;
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);

    foreach(Item* i, m_Player->Items){
        if (!i->GetIsSpecial() && i->GetIsMeal()){
            QLabel* lbl = new QLabel(this);
            lbl->setSizePolicy(stretchZero);
            lbl->setText(QString("<b>%1:</b>").arg(row + 1));
            ui->layItems->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 1);

            lbl = new QLabel(this);
            lbl->setText(i->GetDescription());
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 2);

            QPushButton* pbn = new QPushButton(this);
            connect(pbn, SIGNAL(clicked()), this, SLOT(SelectedSlot()));
            pbn->setObjectName(QString::number(index));
            pbn->setText("Eat");
            pbn->setMaximumSize(75, 50);
            ui->layItems->addWidget(pbn, row, 3);

            row++;
        }
        index++;
    }
}

void ChooseItemWindow::ShowBackpackItems(bool excludeMeals)
{
    setWindowTitle("Choose a item");
    int row=0;
    int index = 0;
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);

    foreach(Item* i, m_Player->Items){
        if (i->GetIsBackpackItem()){
            if (excludeMeals && i->GetIsMeal())
                continue;

            QLabel* lbl = new QLabel(this);
            lbl->setSizePolicy(stretchZero);
            lbl->setText(QString("<b>%1:</b>").arg(row + 1));
            ui->layItems->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 1);

            lbl = new QLabel(this);
            lbl->setText(i->GetDescription());
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 2);

            QPushButton* pbn = new QPushButton(this);
            connect(pbn, SIGNAL(clicked()), this, SLOT(SelectedSlot()));
            pbn->setObjectName(QString::number(index));
            pbn->setText("Select");
            pbn->setMaximumSize(75, 50);
            ui->layItems->addWidget(pbn, row, 3);

            row++;
        }
        index++;
    }
}

void ChooseItemWindow::ShowSpecialItems()
{
    setWindowTitle("Choose a item");
    int row=0;
    int index = 0;
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);

    foreach(Item* i, m_Player->Items){
        if (i->GetIsSpecial()){
            QLabel* lbl = new QLabel(this);
            lbl->setSizePolicy(stretchZero);
            lbl->setText(QString("<b>%1:</b>").arg(row + 1));
            ui->layItems->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 1);

            lbl = new QLabel(this);
            lbl->setText(i->GetDescription());
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 2);

            QPushButton* pbn = new QPushButton(this);
            connect(pbn, SIGNAL(clicked()), this, SLOT(SelectedSlot()));
            pbn->setObjectName(QString::number(index));
            pbn->setText("Select");
            pbn->setMaximumSize(75, 50);
            ui->layItems->addWidget(pbn, row, 3);

            row++;
        }
        index++;
    }
}

void ChooseItemWindow::ShowWeapons(bool special)
{
    setWindowTitle("Choose a weapon");
    int row=0;
    int index = 0;
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);

    foreach(Weapon* w, m_Player->Weapons(special)){
        QLabel* lbl = new QLabel(this);
        lbl->setSizePolicy(stretchZero);
        lbl->setText(QString("<b>%1:</b>").arg(row + 1));
        ui->layItems->addWidget(lbl, row, 0);

        lbl = new QLabel(this);
        lbl->setText(w->Name);
        lbl->setWordWrap(true);
        ui->layItems->addWidget(lbl, row, 1);

        lbl = new QLabel(this);
        lbl->setText(w->GetDescription());
        lbl->setWordWrap(true);
        ui->layItems->addWidget(lbl, row, 2);

        QPushButton* pbn = new QPushButton(this);
        connect(pbn, SIGNAL(clicked()), this, SLOT(SelectedSlot()));
        pbn->setObjectName(QString::number(index));
        pbn->setText("Select");
        pbn->setMaximumSize(75, 50);
        ui->layItems->addWidget(pbn, row, 3);

        row++;
        index++;
    }
}

void ChooseItemWindow::SelectedSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();

    switch (m_Mode)
    {
    case ChooseMeal:
    case ChooseItem:
    case ChooseItemExceptMeals:
    case ChooseSpecialItem:
        m_Selected = m_Player->Items.at(idx);
        break;
    case ChooseWeapon:
        m_Selected = m_Player->Weapons().at(idx);
        break;
    case ChooseWeaponSpecial:
        m_Selected = m_Player->Weapons(true).at(idx);
        break;
    default:
        break;
    }

    accept();
}

void ChooseItemWindow::CancelSlot()
{
    reject();
}
