#include "shopwindow.h"
#include "ui_shopwindow.h"
#include "commonstatic.h"

ShopWindow::ShopWindow(QWidget *parent, Player* player, Section* section) :
    DialogWindow(parent),
    ui(new Ui::ShopWindow)
{
    ui->setupUi(this);
    SetCanClose(true);
#ifndef Q_WS_MAEMO_5
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    CommonStatic::CenterWindow(this);
#endif
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    m_Player = player;
    m_Section = section;

    ui->statusLayout->setAlignment(ui->chkQuiver, Qt::AlignRight);
    connect(ui->pbnDone, SIGNAL(clicked()), this, SLOT(close()));

    ShowData();
}

ShopWindow::~ShopWindow()
{
    delete ui;
}

void ShopWindow::ShowData()
{
    int row = 0;
    QLayoutItem* child;
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);

    while ((child = ui->layPickItems->takeAt(0)) != 0) {
        delete child->widget();
        delete child;
    }

    QLabel* lbl = new QLabel(this);
    lbl->setText("<b>Item</b>");
    ui->layPickItems->addWidget(lbl, row, 0);

    lbl = new QLabel(this);
    lbl->setText("<b>Price</b>");
    lbl->setAlignment(Qt::AlignVCenter | Qt::AlignRight);
    ui->layPickItems->addWidget(lbl, row, 2);
    row++;

    int index = 0;
    foreach(ShopItem* i, m_Section->ShopItems){
        if (i->Price < 0)
            continue;

        lbl = new QLabel(this);
        if (i->GetQuantity() > 1)
            lbl->setText(QString("%1 (%2)").arg(i->Name).arg(i->GetQuantity()));
        else
            lbl->setText(i->Name);
        lbl->setWordWrap(true);
        ui->layPickItems->addWidget(lbl, row, 0);

        lbl = new QLabel(this);
        lbl->setText(i->GetDescription());
        lbl->setWordWrap(true);
        ui->layPickItems->addWidget(lbl, row, 1);

        lbl = new QLabel(this);
        lbl->setText(QString::number(i->Price));
        lbl->setAlignment(Qt::AlignVCenter | Qt::AlignRight);
        ui->layPickItems->addWidget(lbl, row, 2);

        QPushButton* pbn = new QPushButton(this);
        pbn->setObjectName(QString::number(index++));
        pbn->setText("Buy");
        if (i->Price > m_Player->GetGoldCrowns() ||
            (i->GetIsBackpack() && m_Player->HasBackpack()))
            pbn->setEnabled(false);
        pbn->setMaximumSize(75, 50);
        connect(pbn, SIGNAL(clicked()), this, SLOT(BuyItemSlot()));
        ui->layPickItems->addWidget(pbn, row, 3);
        row++;
    }

    switch (((Book*)m_Section->parent())->GetSerie()){
    case Book::Kai:
        ui->lblQuiver->setVisible(false);
        ui->chkQuiver->setVisible(false);
        ui->lblArrowsD->setVisible(false);
        ui->lblArrows->setVisible(false);
        break;
    default:
        break;
    }

    ui->lblCrowns->setText(QString::number(m_Player->GetGoldCrowns()));
    ui->lblArrows->setText(QString("%1/%2")
                           .arg(m_Player->GetArrows())
                           .arg(m_Player->GetMaxArrows()));
    ui->chkQuiver->setChecked(m_Player->HasQuiver());
    ui->pbnDropWeapon1->setEnabled(false);
    ui->pbnDropWeapon2->setEnabled(false);
    int sell = 0;
    ui->lblSellPrice1->setText("");
    ui->lblSellPrice2->setText("");
    QList<Weapon*> weapons = m_Player->Weapons();
    if (weapons.count() > 0){
        ui->lblWeapon1->setText(weapons.at(0)->Name);
        ui->pbnDropWeapon1->setEnabled(true);
        sell = GetSellPrice(weapons.at(0));
        disconnect(ui->pbnDropWeapon1, SIGNAL(clicked()), 0, 0);
        if (sell){
            ui->lblSellPrice1->setText(QString::number(sell));
            ui->pbnDropWeapon1->setText("Sell");
            connect(ui->pbnDropWeapon1, SIGNAL(clicked()), this, SLOT(SellWeapon1Slot()));
        }else
            connect(ui->pbnDropWeapon1, SIGNAL(clicked()), this, SLOT(DropWeapon1Slot()));
    }else{
        ui->lblWeapon1->setText("-");
    }

    if (weapons.count() > 1){
        ui->lblWeapon2->setText(weapons.at(1)->Name);
        ui->pbnDropWeapon2->setEnabled(true);
        sell = GetSellPrice(weapons.at(1));
        disconnect(ui->pbnDropWeapon2, SIGNAL(clicked()), 0, 0);
        if (sell){
            ui->lblSellPrice2->setText(QString::number(sell));
            ui->pbnDropWeapon2->setText("Sell");
            connect(ui->pbnDropWeapon2, SIGNAL(clicked()), this, SLOT(SellWeapon2Slot()));
        }else
            connect(ui->pbnDropWeapon2, SIGNAL(clicked()), this, SLOT(DropWeapon2Slot()));
    }else{
        ui->lblWeapon2->setText("-");
    }

    while ((child = ui->layItems->takeAt(0)) != 0) {
        delete child->widget();
        delete child;
    }

    row = 0;
    index = 0;
    if (!m_Player->HasBackpack()){
        QLabel* lbl = new QLabel(this);
        lbl->setText("You don't have the backpack!");
        ui->layItems->addWidget(lbl, 0, 0);
    }else{
        foreach(Item* i, m_Player->Items){
            if (i->GetIsBackpackItem()){
                QLabel* lbl = new QLabel(this);
                lbl->setSizePolicy(stretchZero);
                lbl->setText(QString("<b>%1:</b>").arg(row + 1));
                ui->layItems->addWidget(lbl, row, 0);

                lbl = new QLabel(this);
                lbl->setText(i->Name);
                lbl->setWordWrap(true);
                ui->layItems->addWidget(lbl, row, 1);

                lbl = new QLabel(this);
                lbl->setText(i->Description);
                lbl->setWordWrap(true);
                ui->layItems->addWidget(lbl, row, 2);

                QPushButton* pbn = new QPushButton(this);
                pbn->setObjectName(QString::number(index));

                int sell = GetSellPrice(i);
                if (sell){
                    pbn->setText("Sell");
                    connect(pbn, SIGNAL(clicked()), this, SLOT(SellItemSlot()));
                }else{
                    pbn->setText("Discard");
                    connect(pbn, SIGNAL(clicked()), this, SLOT(DropItemSlot()));
                }
                pbn->setMaximumSize(75, 50);
                ui->layItems->addWidget(pbn, row, 3);

                row++;
            }
            index++;
        }
    }
}

void ShopWindow::BuyItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    ShopItem* i = m_Section->ShopItems.at(idx);

    if (i->IsWeapon() && m_Player->WeaponsCount() == 2){
        QMessageBox msgBox(this);
        msgBox.setText("You cannot carry more than two weapons.");
        msgBox.exec();
        return;
    }else{
        if (i->GetIsArrow() && !m_Player->HasQuiver()){
            QMessageBox msgBox(this);
            msgBox.setText("You don't have the quiver and cannot carry arrows.");
            msgBox.exec();
            return;
        }

        if (i->GetIsArrow() && m_Player->GetArrows() == m_Player->GetMaxArrows()){
            QMessageBox msgBox(this);
            msgBox.setText("You cannot carry more arrows.");
            msgBox.exec();
            return;
        }

        if (!i->GetIsSpecial() && !m_Player->HasBackpack()){
            QMessageBox msgBox(this);
            msgBox.setText("You don't have the backpack and cannot carry any item.");
            msgBox.exec();
            return;
        }

        if (!i->GetIsSpecial() && m_Player->IsBackpackFull()){
            QMessageBox msgBox(this);
            msgBox.setText("You cannot carry more items.");
            msgBox.exec();
            return;
        }
    }

    if (CommonStatic::ConfirmMessage(this, "Confirm", QString("Buy a %1 for %2 Gold Crown(s)?").arg(i->Name).arg(i->Price)) == QMessageBox::Yes){
        m_Player->SetGoldCrowns(m_Player->GetGoldCrowns() - i->Price);
        qDebug() << "IsWeapon=" << i->IsWeapon();
        if (i->IsWeapon())
            m_Player->Items.append((Weapon*)i);
        else{
            if (i->GetIsArrow())
                m_Player->SetArrows(m_Player->GetArrows() + i->GetQuantity());
            else if (i->GetIsBackpack())
                m_Player->SetHasBackpack(true);
            else
                m_Player->Items.append((Item*)i);
        }
        if (!i->UnlimitedQuantity)
            m_Section->ShopItems.removeOne(i);
        ShowData();
    }
}

void ShopWindow::SellItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    Item* i = m_Player->Items.at(idx);
    int price = GetSellPrice(i);
    if (SellItem(i, price)){
        ShowData();
    }
}

void ShopWindow::DropItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    Item* i = m_Player->Items.at(idx);
    if (DropItem(i)){
        ShowData();
    }
}

bool ShopWindow::SellItem(Item* item, int price)
{
if (CommonStatic::ConfirmMessage(this, "Confirm", QString("Sell the %1 for %2 Gold Crowns?").arg(item->Name).arg(price)) == QMessageBox::Yes){
        item->Unequip();
        m_Player->CheckEndurance();
        m_Player->Items.removeOne(item);
        delete item;
        m_Player->SetGoldCrowns(m_Player->GetGoldCrowns() + price);
        return true;
    }
    return false;
}

bool ShopWindow::DropItem(Item* item)
{
    if (CommonStatic::ConfirmMessage(this, "Confirm", QString("Discard the %1?").arg(item->Name)) == QMessageBox::Yes){
        item->Unequip();
        m_Player->CheckEndurance();
        m_Player->Items.removeOne(item);
        delete item;
        return true;
    }
    return false;
}

void ShopWindow::SellWeapon1Slot()
{
    Weapon* w = m_Player->Weapons().at(0);
    if (SellWeapon(w, ui->lblSellPrice1->text().toInt()))
        ShowData();
}

void ShopWindow::SellWeapon2Slot()
{
    Weapon* w = m_Player->Weapons().at(1);
    if (SellWeapon(w, ui->lblSellPrice2->text().toInt()))
        ShowData();
}

void ShopWindow::DropWeapon1Slot()
{
    Weapon* w = m_Player->Weapons().at(0);
    if (DropWeapon(w))
        ShowData();
}

void ShopWindow::DropWeapon2Slot()
{
    Weapon* w = m_Player->Weapons().at(1);
    if (DropWeapon(w))
        ShowData();
}

bool ShopWindow::SellWeapon(Weapon* weapon, int price)
{
    if (CommonStatic::ConfirmMessage(this, "Confirm", QString("Sell the %1 for %2 Gold Crowns?").arg(weapon->Name).arg(price)) == QMessageBox::Yes){
        weapon->Unequip();
        m_Player->CheckEndurance();
        m_Player->Items.removeOne(weapon);
        delete weapon;
        m_Player->SetGoldCrowns(m_Player->GetGoldCrowns() + price);
        return true;
    }
    return false;
}

bool ShopWindow::DropWeapon(Weapon* weapon)
{
    if (CommonStatic::ConfirmMessage(this, "Confirm", QString("Discard the %1?").arg(weapon->Name)) == QMessageBox::Yes){
        weapon->Unequip();
        m_Player->CheckEndurance();
        m_Player->Items.removeOne(weapon);
        delete weapon;
        return true;
    }
    return false;
}

int ShopWindow::GetSellPrice(Item* i)
{
    Weapon* w = qobject_cast<Weapon*>(i);
    if (w){
        foreach(ShopItem* s, m_Section->ShopItems){
            if (s->SellPrice > 0 && s->IsWeapon()){
                foreach(int c, w->Classes()){
                    if (s->Classes().contains(c))
                        return s->SellPrice;
                }
            }
        }
        return 0;
    }

    foreach(ShopItem* s, m_Section->ShopItems){
        if (s->SellPrice > 0 && QString::compare(s->Name, i->Name) == 0)
            return s->SellPrice;
    }
    return 0;
}
