#ifndef PORTHOLESWINDOW_H
#define PORTHOLESWINDOW_H

#include <QMainWindow>
#include <QEventLoop>
#include "controls/dialogwindow.h"
#include "core/player.h"
#include "randomnumberpicker.h"

namespace Ui {
    class PortholesWindow;
}

class PortholesWindow : public DialogWindow
{
    Q_OBJECT

public:
    explicit PortholesWindow(QWidget *parent = 0, Player* player=0);
    ~PortholesWindow();

private:
    Ui::PortholesWindow *ui;

    int m_CurrentPlayer;
    int m_Random1;
    int m_Random2;
    RandomNumberPicker* m_RandomPicker1;
    RandomNumberPicker* m_RandomPicker2;
    Player* m_Player;

    void UpdateData();
    void Play(int player);
    void Evaluate();

private slots:
    void RandomSlot(int);
    void PlaySlot();
};

#endif // PORTHOLESWINDOW_H
