#include "statuswindow.h"
#include "ui_statuswindow.h"

#include <QPushButton>
#ifdef Q_WS_MAEMO_5
#include <QMaemo5Style>
#endif
#include "commonstatic.h"

StatusWindow::StatusWindow(QWidget *parent, int serie, Player* player, Section* section, QScriptEngine* engine, QScriptValue* functions) :
    QMainWindow(parent),
    ui(new Ui::StatusWindow)
{
    ui->setupUi(this);
#ifndef Q_WS_MAEMO_5
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    CommonStatic::CenterWindow(this);
#endif
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    setAttribute(Qt::WA_Maemo5StackedWindow);

    QColor secondaryColor = QMaemo5Style::standardColor("SecondaryTextColor");
    QPalette secondaryPalette(QColor(255,255,255, 0));
    secondaryPalette.setColor(QPalette::Foreground, secondaryColor);

    ui->lblSectionItems->setPalette(secondaryPalette);
    ui->lblStatus->setPalette(secondaryPalette);
    ui->lblDisciplines->setPalette(secondaryPalette);
    ui->lblWeapons->setPalette(secondaryPalette);
    ui->lblItems->setPalette(secondaryPalette);
    ui->lblSpecialItems->setPalette(secondaryPalette);
    ui->lblEquippedWeapons->setPalette(secondaryPalette);
    ui->lblEquippedArmor->setPalette(secondaryPalette);
#endif

    connect(ui->pbnDropWeapon1, SIGNAL(clicked()), this, SLOT(DropWeapon1Slot()));
    connect(ui->pbnDropWeapon2, SIGNAL(clicked()), this, SLOT(DropWeapon2Slot()));
    connect(ui->pbnEquip1, SIGNAL(clicked()), this, SLOT(EquipWeapon1Slot()));
    connect(ui->pbnEquip2, SIGNAL(clicked()), this, SLOT(EquipWeapon2Slot()));
    connect(ui->pbnPickGoldCrowns, SIGNAL(clicked()), this, SLOT(TakeGoldCrownsSlot()));

    m_Serie = serie;
    m_Engine = engine;
    m_Functions = functions;
    m_Section = section;
    m_Player = player;
    ShowData();
}

StatusWindow::~StatusWindow()
{
    delete ui;
}

void StatusWindow::closeEvent(QCloseEvent*)
{
    if (m_Loop)
        m_Loop->quit();
    QMainWindow::close();
}

void StatusWindow::exec()
{
    m_Loop = new QEventLoop(this);
    show();
    m_Loop->exec();
}

void StatusWindow::ShowData()
{
    if (!m_Section || !m_Section->HasPickableItems()){
        ui->lblSectionItems->setVisible(false);
        ui->lineSection->setVisible(false);

        ClearLayout(ui->laySectionCrowns);
        ClearLayout(ui->laySectionItems);
    }else{
        ui->lblSectionItems->setVisible(true);

        ClearLayout(ui->laySectionItems);
        if (m_Section->GoldCrowns > 0){
            ui->lblSecGoldCrowns->setText(QString::number(m_Section->GoldCrowns));
            if (m_Player->GoldCrowns == 50)
                ui->pbnPickGoldCrowns->setEnabled(false);
        }else{
            ClearLayout(ui->laySectionCrowns);
        }

        int row = 1;
        foreach(Item* i, m_Section->Items){
            QLabel* lbl = new QLabel(this);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->laySectionItems->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->Description);
            lbl->setWordWrap(true);
            ui->laySectionItems->addWidget(lbl, row, 1);

            QPushButton* pbn = new QPushButton(this);
            pbn->setObjectName(QString::number(row - 1));
            pbn->setText("Take");
            pbn->setMaximumSize(75, 50);
            connect(pbn, SIGNAL(clicked()), this, SLOT(TakeItemSlot()));
            ui->laySectionItems->addWidget(pbn, row, 2);
            row++;
        }
    }

    ui->lblSkill->setText(QString::number(m_Player->GetCombatSkill()));
    ui->lblEndurance->setText(QString("%1/%2").arg(m_Player->Endurance).arg(m_Player->GetBaseEndurance()));
    ui->lblCrowns->setText(QString("%1/50").arg(m_Player->GoldCrowns));
    ui->lblMeals->setText(QString::number(m_Player->MealsCount()));

    QList<Weapon*> weapons = m_Player->Weapons();
    ui->pbnDropWeapon1->setEnabled(false);
    ui->pbnEquip1->setEnabled(false);
    ui->pbnDropWeapon2->setEnabled(false);
    ui->pbnEquip2->setEnabled(false);
    if (weapons.count() > 0){
        ui->lblWeapon1->setText(weapons.at(0)->Name);
        ui->pbnDropWeapon1->setEnabled(true);
        ui->pbnEquip1->setEnabled(weapons.at(0)->GetCanBeEquipped());
        if (weapons.at(0)->GetIsEquipped()){
            ui->pbnEquip1->setText("Unequip");
#ifdef Q_WS_MAEMO_5
            ui->pbnEquip1->setFixedWidth(120);
#endif
        }else{
            ui->pbnEquip1->setText("Equip");
#ifdef Q_WS_MAEMO_5
            ui->pbnEquip1->setFixedWidth(75);
#endif
        }
    }else{
        ui->lblWeapon1->setText("-");
    }

    if (weapons.count() > 1){
        ui->lblWeapon2->setText(weapons.at(1)->Name);
        ui->pbnDropWeapon2->setEnabled(true);
        ui->pbnEquip2->setEnabled(weapons.at(1)->GetCanBeEquipped());
        if (weapons.at(1)->GetIsEquipped()){
            ui->pbnEquip2->setText("Unequip");
#ifdef Q_WS_MAEMO_5
            ui->pbnEquip2->setFixedWidth(120);
#endif
        }else{
            ui->pbnEquip2->setText("Equip");
#ifdef Q_WS_MAEMO_5
            ui->pbnEquip2->setFixedWidth(75);
#endif
        }
    }else{
        ui->lblWeapon2->setText("-");
    }

    ClearLayout(ui->layEquippedWeapons);
    int row = 0;
    foreach(Item* w, m_Player->Items){
        if (w->GetIsWeapon() && w->GetIsEquipped()){
            QLabel* lbl = new QLabel(this);
            lbl->setText(w->Name);
            lbl->setWordWrap(true);
            ui->layEquippedWeapons->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(w->Description);
            lbl->setWordWrap(true);
            ui->layEquippedWeapons->addWidget(lbl, row, 1);
            row++;
        }
    }
    if (!row){
        QLabel* lbl = new QLabel(this);
        lbl->setText("None");
        lbl->setWordWrap(true);
        ui->layEquippedWeapons->addWidget(lbl, row, 0);
    }

    ClearLayout(ui->layEquippedArmor);
    row = 0;
    foreach(Item* i, m_Player->Items){
        if (i->GetIsArmor() && i->GetIsEquipped()){
            QLabel* lbl = new QLabel(this);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->layEquippedArmor->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->Description);
            lbl->setWordWrap(true);
            ui->layEquippedArmor->addWidget(lbl, row, 1);
            row++;
        }
    }
    if (!row){
        QLabel* lbl = new QLabel(this);
        lbl->setText("None");
        lbl->setWordWrap(true);
        ui->layEquippedArmor->addWidget(lbl, row, 0);
    }

    ClearLayout(ui->layKaiDisciplines);
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);
    QSizePolicy stretchOne;
    stretchOne.setHorizontalStretch(1);
    row = 0;
    foreach (KaiDiscipline* d, m_Player->KaiDisciplines){
        QLabel* lbl = new QLabel(this);
        lbl->setSizePolicy(stretchZero);
        lbl->setText(QString("<b>%1:</b>").arg(row + 1));
        ui->layKaiDisciplines->addWidget(lbl, row, 0);

        lbl = new QLabel(this);
        lbl->setText(d->Description());
        ui->layKaiDisciplines->addWidget(lbl, row, 1);
        lbl = new QLabel(this);
        lbl->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
        lbl->setText(Player::GetRankDescription(row + 1));
        ui->layKaiDisciplines->addWidget(lbl, row, 2);
        row++;
    }

    ClearLayout(ui->layItems);
    row = 0;
    int index = 0;

    if (!m_Player->HasBackpack()){
        QLabel* lbl = new QLabel(this);
        lbl->setText("You don't have the backpack!");
        ui->layItems->addWidget(lbl, 0, 0);
    }else{
        foreach(Item* i, m_Player->Items){
            if (i->GetIsBackpackItem()){
                QLabel* lbl = new QLabel(this);
                lbl->setSizePolicy(stretchZero);
                lbl->setText(QString("<b>%1:</b>").arg(row + 1));
                ui->layItems->addWidget(lbl, row, 0);

                lbl = new QLabel(this);
                lbl->setText(i->Name);
                lbl->setWordWrap(true);
                ui->layItems->addWidget(lbl, row, 1);

                lbl = new QLabel(this);
                lbl->setText(i->Description);
                lbl->setWordWrap(true);
                ui->layItems->addWidget(lbl, row, 2);

                QPushButton* pbn = new QPushButton(this);
                pbn->setObjectName(QString::number(index));
                if (i->GetIsMeal())
                    pbn->setText("Eat");
                else
                    pbn->setText("Use");
                pbn->setEnabled(i->IsUsable());
                pbn->setMaximumSize(75, 50);
                connect(pbn, SIGNAL(clicked()), this, SLOT(UseItemSlot()));
                ui->layItems->addWidget(pbn, row, 3);

                pbn = new QPushButton(this);
                pbn->setObjectName(QString::number(index));
                pbn->setText("Drop");
                pbn->setMaximumSize(75, 50);
                connect(pbn, SIGNAL(clicked()), this, SLOT(DropItemSlot()));
                ui->layItems->addWidget(pbn, row, 4);

                row++;
                for (int j=1; j<i->GetSize(); j++){
                    QLabel* lbl = new QLabel(this);
                    lbl->setSizePolicy(stretchZero);
                    lbl->setText(QString("<b>%1:</b>").arg(row + 1));
                    ui->layItems->addWidget(lbl, row, 0);

                    lbl = new QLabel(this);
                    lbl->setText("-");
                    lbl->setWordWrap(true);
                    ui->layItems->addWidget(lbl, row, 1);

                    row++;
                }
            }
            index++;
        }

        for (int i=row; i<8; i++){
            QLabel* lbl = new QLabel(this);
            lbl->setSizePolicy(stretchZero);
            lbl->setText(QString("<b>%1:</b>").arg(i + 1));
            ui->layItems->addWidget(lbl, i, 0);

            lbl = new QLabel(this);
            lbl->setText("");
            lbl->setWordWrap(true);
            ui->layItems->addWidget(lbl, row, 1);

            QPushButton* pbn = new QPushButton(this);
            pbn->setText("Use");
            pbn->setEnabled(false);
            pbn->setMaximumSize(75, 50);
            ui->layItems->addWidget(pbn, i, 3);

            pbn = new QPushButton(this);
            pbn->setText("Drop");
            pbn->setEnabled(false);
            pbn->setMaximumSize(75, 50);
            ui->layItems->addWidget(pbn, i, 4);

        }
    }

    ClearLayout(ui->laySpecialItems);
    row = 0;
    index = 0;
    foreach(Item* i, m_Player->Items){
        if (i->GetIsSpecial()){
            QLabel* lbl = new QLabel(this);
            lbl->setText(i->Name);
            lbl->setWordWrap(true);
            ui->laySpecialItems->addWidget(lbl, row, 0);

            lbl = new QLabel(this);
            lbl->setText(i->Description);
            lbl->setWordWrap(true);
            ui->laySpecialItems->addWidget(lbl, row, 1);

            if(i->GetIsWeapon() || i->GetIsArmor()){
                QPushButton* pbn = new QPushButton(this);
                pbn->setEnabled(i->GetCanBeEquipped());
                pbn->setObjectName(QString::number(index));
                if (i->GetIsEquipped()){
                    pbn->setText("Unequip");
#ifdef Q_WS_MAEMO_5
                    pbn->setMaximumSize(120, 50);
#endif
                }else{
                    pbn->setText("Equip");
#ifdef Q_WS_MAEMO_5
                    pbn->setMaximumSize(75, 50);
#endif
                }
#ifndef Q_WS_MAEMO_5
                pbn->setMaximumSize(75, 50);
#endif
                connect(pbn, SIGNAL(clicked()), this, SLOT(EquipItemSlot()));
                ui->laySpecialItems->addWidget(pbn, row, 2);
            }

            QPushButton* pbn = new QPushButton(this);
            pbn->setObjectName(QString::number(index));
            pbn->setText("Drop");
            pbn->setMaximumSize(75, 50);
            connect(pbn, SIGNAL(clicked()), this, SLOT(DropItemSlot()));
            ui->laySpecialItems->addWidget(pbn, row, 3);

            row++;
        }
        index++;
    }
}

bool StatusWindow::EquipWeapon(Weapon* weapon)
{
    if (weapon->GetIsEquipped()){
        weapon->Unequip();
        m_Player->CheckEndurance();
    }else{
        Weapon* equipped = m_Player->GetEquippedWeapon();
        if (equipped != NULL)
            equipped->Unequip();
        weapon->Equip();
    }
    return true;
}

void StatusWindow::EquipWeapon1Slot()
{
    Weapon* w = m_Player->Weapons().at(0);
    if (EquipWeapon(w))
        ShowData();
}

void StatusWindow::EquipWeapon2Slot()
{
    Weapon* w = m_Player->Weapons().at(1);
    if (EquipWeapon(w))
        ShowData();
}

void StatusWindow::DropWeapon1Slot()
{
    Weapon* w = m_Player->Weapons().at(0);
    if (DropWeapon(w))
        ShowData();
}

void StatusWindow::DropWeapon2Slot()
{
    Weapon* w = m_Player->Weapons().at(1);
    if (DropWeapon(w))
        ShowData();
}

bool StatusWindow::DropWeapon(Weapon* weapon)
{
    if (CommonStatic::ConfirmMessage(this, "Confirm", QString("Drop the %1?").arg(weapon->Name)) == QMessageBox::Yes){
        weapon->Unequip();
        m_Player->CheckEndurance();
        m_Player->Items.removeOne(weapon);
        if (m_Section)
            m_Section->Items.append(weapon);
        else
            delete weapon;
        return true;
    }
    return false;
}

void StatusWindow::EquipItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    Item* i = m_Player->Items.at(idx);
    if (i->GetIsEquipped()){
        i->Unequip();
        m_Player->CheckEndurance();
        ShowData();
    }else{
        if (i->GetIsWeapon()){
            Weapon* w = (Weapon*)i;
            if (EquipWeapon(w))
                ShowData();
        }else if (i->GetIsArmor()){
            if (m_Player->GetFreeHands() < i->GetHands()){
                QMessageBox msgBox(this);
                msgBox.setText("You cannot equip this item now.");
                msgBox.exec();
            }else{
                i->Equip();
                ShowData();
            }
        }
    }
}

void StatusWindow::DropItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    Item* i = m_Player->Items.at(idx);
    if (DropItem(i)){
        if (m_Player->Endurance > m_Player->GetBaseEndurance())
            m_Player->Endurance = m_Player->GetBaseEndurance();
        ShowData();
    }
}

bool StatusWindow::DropItem(Item* item)
{
    if (CommonStatic::ConfirmMessage(this, "Confirm", QString("Drop the %1?").arg(item->Name)) == QMessageBox::Yes){
        item->Unequip();
        m_Player->CheckEndurance();
        m_Player->Items.removeOne(item);
        if (m_Section)
            m_Section->Items.append(item);
        else
            delete item;
        return true;
    }
    return false;
}

void StatusWindow::TakeItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    Item* i = m_Section->Items.at(idx);

    Weapon* w = qobject_cast<Weapon*>(i);
    if (w && !w->GetIsSpecial()){
        //Take weapon:
        if (m_Player->Weapons().count() == 2){
            QMessageBox msgBox(this);
            msgBox.setText("You cannot carry more than two weapons.");
            msgBox.exec();
            return;
        }else{
            m_Player->Items.append(w);
            m_Section->Items.removeOne(w);
            ShowData();
            return;
        }
    }

    if (i->GetIsSpecial()){
        //Take special item:
        m_Player->Items.append(i);
        m_Section->Items.removeOne(i);
        ShowData();
        return;
    }else{
        //Take normal item:
        if (!m_Player->HasBackpack() && i->GetIsBackpack()){
            m_Player->SetHasBackpack(true);
            m_Section->Items.removeOne(i);
            ShowData();
            return;
        }else if (!m_Player->HasBackpack()){
            QMessageBox msgBox(this);
            msgBox.setText("You don't have the backpack and cannot carry any item.");
            msgBox.exec();
            return;
        }else if (m_Player->HasBackpack() && i->GetIsBackpack()){
            QMessageBox msgBox(this);
            msgBox.setText("You have the backpack and cannot carry another one.");
            msgBox.exec();
            return;
        }else if (m_Player->IsBackpackFull()){
            QMessageBox msgBox(this);
            msgBox.setText("You cannot carry more items.");
            msgBox.exec();
            return;
        }else{
            m_Player->Items.append(i);
            m_Section->Items.removeOne(i);
            ShowData();
            return;
        }
    }
}

void StatusWindow::TakeGoldCrownsSlot()
{
    int toTake = m_Section->GoldCrowns;
    if (m_Player->GoldCrowns + m_Section->GoldCrowns > 50)
        toTake = 50 - m_Player->GoldCrowns;
    m_Player->GoldCrowns += toTake;
    m_Section->GoldCrowns -= toTake;

    ShowData();
}

void StatusWindow::UseItemSlot()
{
    int idx = ((QWidget*)sender())->objectName().toInt();
    Item* i = m_Player->Items.at(idx);

    QMessageBox::StandardButton res = QMessageBox::No;

    if (i->GetIsMeal())
        res = CommonStatic::ConfirmMessage(this, "Confirm", QString("Eat the %1?").arg(i->Name));
    else
        res = CommonStatic::ConfirmMessage(this, "Confirm", QString("Use the %1?").arg(i->Name));

    if (res == QMessageBox::Yes){
        i->Use(m_Engine, m_Functions);
        m_UsedItems.append(i);
        m_Player->Items.removeOne(i);
        ShowData();
    }
}

void StatusWindow::ClearLayout(QLayout* layout)
{
    QLayoutItem* child;
    while ((child = layout->takeAt(0)) != 0) {
        delete child->widget();
        delete child;
    }
}
