#ifndef CHOOSEITEMWINDOW_H
#define CHOOSEITEMWINDOW_H

#include <QDialog>
#include "core/player.h"

namespace Ui {
    class ChooseItemWindow;
}

class ChooseItemWindow : public QDialog
{
    Q_OBJECT

public:
    enum ChooseMode{
        ChooseMeal,
        ChooseItem,
        ChooseSpecialItem,
        ChooseWeapon
    };

    explicit ChooseItemWindow(QWidget *parent = 0, Player* player=0, int mode=ChooseMeal);
    ~ChooseItemWindow();

    Item* SelectedItem() { return m_Selected; }

protected:
    void closeEvent(QCloseEvent *event);

private:
    Ui::ChooseItemWindow *ui;

    int m_Mode;
    bool m_Close;
    Player* m_Player;
    Item* m_Selected;

    void ShowItems();

    void ShowBackpackItems();
    void ShowSpecialItems();
    void ShowMeals();
    void ShowWeapons();

private slots:
    void SelectedSlot();
};

#endif // CHOOSEITEMWINDOW_H
