#ifndef BONUSDISCIPLINEWINDOW_H
#define BONUSDISCIPLINEWINDOW_H

#include <QDialog>
#include <QCheckBox>
#include "core/player.h"
#include "controls/dialogwindow.h"
#include "randomnumberpicker.h"

namespace Ui {
    class BonusDisciplineWindow;
}

class BonusDisciplineWindow : public DialogWindow
{
    Q_OBJECT

public:
    explicit BonusDisciplineWindow(QWidget *parent = 0, Book* book=0, Player* player=0, int number=1);
    ~BonusDisciplineWindow();

private:
    Ui::BonusDisciplineWindow *ui;

    int m_Number;
    int m_Selected;
    Book* m_Book;
    RandomNumberPicker* m_RandomPicker;
    int m_Serie;
    Player* m_Player;
    QList<KaiDiscipline*> m_List;
    QList<QPushButton*> m_Buttons;
    QList<QCheckBox*> m_CheckButtons;

    QStringList m_Elements;
    QString m_RandomSender;

    void ShowData();
    KaiDiscipline* GetDiscipline(QString name);
    void AddWeaponMastery();
    void CheckWeaponMasteryBonus();

private slots:
    void ChooseSlot();
    void RandomSlot();
    void GetRandomSlot(int);
    void DiscipleLinkSlot(QString link);
    void SelectSlot(bool selected);
    void OkSlot();
};

#endif // BONUSDISCIPLINEWINDOW_H
