#include "qdisabledcheckbox.h"

QDisabledCheckBox::QDisabledCheckBox(QWidget*parent) :
    QCheckBox(parent)
{
    m_Enabled = true;
    m_IgnoreChanges = false;
    connect(this, SIGNAL(toggled(bool)), this, SLOT(ToggledSlot(bool)));
}

void QDisabledCheckBox::setEnabled(bool enabled)
{
    m_Enabled = enabled;
}

void QDisabledCheckBox::ToggledSlot(bool checked)
{
    if (m_IgnoreChanges || m_Enabled)
        return;
    m_IgnoreChanges = true;
    setChecked(!checked);
    m_IgnoreChanges = false;
}
