//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "aboutwindow.h"
#include "ui_aboutwindow.h"
#include <QFile>
#include "texteditautoresizer.h"
#include <QDesktopServices>
#include <QUrl>

AboutWindow::AboutWindow(QWidget *parent) :
    DialogWindow(parent),
    ui(new Ui::AboutWindow)
{
    ui->setupUi(this);
    SetCanClose(true);
#ifdef Q_OS_SYMBIAN
    QAction* backSoftKey = new QAction( tr("Back"), this );
    backSoftKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(backSoftKey, SIGNAL(triggered()), this, SLOT(accept()));
    addAction(backSoftKey);
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5NonComposited, true);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->scrollArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
#endif
    new TextEditAutoResizer(ui->txtAbout);
    new TextEditAutoResizer(ui->txtLicense);

    connect(ui->btnDonate, SIGNAL(clicked()), this, SLOT(DonateSlot()));
}

AboutWindow::~AboutWindow()
{
    delete ui;
}

void AboutWindow::Init()
{
    QFile* file = new QFile(":/ABOUT.HTML");
    if (file->open(QIODevice::ReadOnly | QIODevice::Text)){
        QByteArray data = file->readAll();
        QString about = QString::fromUtf8(data);
        about.replace("%VERSION%", QCoreApplication::applicationVersion());
        ui->txtAbout->setHtml(about);
        file->close();
    }
    delete file;

    file = new QFile(":/LICENSE.HTML");
    if (file->open(QIODevice::ReadOnly | QIODevice::Text)){
        QByteArray data = file->readAll();
        ui->txtLicense->setHtml(QString::fromUtf8(data));
        file->close();
    }
    delete file;
}

void AboutWindow::resizeEvent(QResizeEvent*)
{
    //Update license text to let TextEditAutoResizer resize the QTextEdit
    ui->txtLicense->setHtml(ui->txtLicense->toHtml());
}

void AboutWindow::DonateSlot()
{
    QUrl url("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=7H6TCVLG4LTYN");
    QDesktopServices::openUrl(url);
}
