#include "bonusdisciplinewindow.h"
#include "ui_bonusdisciplinewindow.h"
#include <QPushButton>
#include "ruleswindow.h"
#include "selectfromlistwindow.h"

BonusDisciplineWindow::BonusDisciplineWindow(QWidget *parent, Book* book, Player* player, int number) :
    DialogWindow(parent),
    ui(new Ui::BonusDisciplineWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif        

    m_RandomPicker = new RandomNumberPicker(this, ui->lblDice, true);
    connect(m_RandomPicker, SIGNAL(Random(int)), SLOT(GetRandomSlot(int)));
    connect(ui->pbnOk, SIGNAL(clicked()), SLOT(OkSlot()));

    m_Number = number;
    m_Selected = 0;
    m_Book = book;
    m_Serie = m_Book->GetSerie();
    m_Player = player;

    switch (m_Serie){
    case Book::Kai:
        m_List << new Camouflage(m_Player) << new Hunting(m_Player) << new SixthSense(m_Player)
               << new Tracking(m_Player) << new Healing(m_Player) << new Weaponskill(m_Player)
               << new Mindshield(m_Player) << new Mindblast(m_Player) << new AnimalKinship(m_Player)
               << new MindOverMatter(m_Player);
        break;
    case Book::Magnakai:
        m_List << new Weaponmastery(m_Player) << new AnimalControl(m_Player) << new Curing(m_Player)
               << new Invisibility(m_Player) << new Huntmastery(m_Player) << new Pathsmanship(m_Player)
               << new PsiSurge(m_Player) << new PsiScreen(m_Player) << new Nexus(m_Player)
               << new Divination(m_Player);
        break;
    default:
        break;
    }

    ShowData();
}

BonusDisciplineWindow::~BonusDisciplineWindow()
{
    delete ui;
}

void BonusDisciplineWindow::ShowData()
{
    QLayoutItem* child;
    while ((child = ui->layKaiDisciplines->takeAt(0)) != 0) {
        delete child->widget();
        delete child;
    }

    ui->lblBonus->setText(m_Number == 1 ? "Choose a bonus discipline:" :
                                          QString("Choose %1 bonus disciplines:").arg(m_Number));
    ui->pbnOk->setVisible(m_Number > 1);
    ui->pbnOk->setEnabled(m_Selected == m_Number);
    m_Buttons.clear();
    m_CheckButtons.clear();
    int row = 0;
    foreach (KaiDiscipline* d, m_List){
        if (!m_Player->HasDiscipline(d->Name)){
            QLabel* lbl = new QLabel(this);
            lbl->setText(QString("<a href=\"%1\">%2</a>").arg(d->Name.toLower().replace(" ", ""))
                                                         .arg(d->Description()));
            ui->layKaiDisciplines->addWidget(lbl, row, 0);
            connect(lbl, SIGNAL(linkActivated(QString)), this, SLOT(DiscipleLinkSlot(QString)));

            if (m_Number == 1){
                bool done = false;
                QPushButton* pbn = new QPushButton(this);
                pbn->setObjectName(d->Name);
                if (d->Name == "Weaponskill"){
                    Weaponskill* ws = qobject_cast<Weaponskill*>(d);
                    if (ws && ws->Weapon == Weapon::None){
                        pbn->setText("Pick");
                        connect(pbn, SIGNAL(clicked()), this, SLOT(RandomSlot()));
                        done = true;
                    }
                }
                if (!done){
                    pbn->setText("Choose");
#ifdef Q_WS_MAEMO_5
                    pbn->setFixedWidth(120);
#endif
                    connect(pbn, SIGNAL(clicked()), this, SLOT(ChooseSlot()));
                }
                pbn->setMaximumSize(75, 50);
                ui->layKaiDisciplines->addWidget(pbn, row, 1);
                m_Buttons.append(pbn);
            }else{
                QCheckBox* chk = new QCheckBox(this);
                chk->setObjectName(d->Name);
                connect(chk, SIGNAL(clicked(bool)), this, SLOT(SelectSlot(bool)));
                ui->layKaiDisciplines->addWidget(chk, row, 1, Qt::AlignRight);
                m_CheckButtons.append(chk);
            }
            row++;
        }
    }
}

KaiDiscipline* BonusDisciplineWindow::GetDiscipline(QString name)
{
    foreach (KaiDiscipline* d, m_List){
        if (!QString::compare(d->Name, name))
            return d;
    }
    return NULL;
}

void BonusDisciplineWindow::ChooseSlot()
{
    CheckWeaponMasteryBonus();

    QString name = sender()->objectName();
    switch (m_Serie){
    case Book::Kai:
    case Book::Magnakai:
        {
            KaiDiscipline* d = GetDiscipline(name);
            if (d){
                if (name == "Weaponmastery"){
                    AddWeaponMastery();
                    Weaponmastery* wm = qobject_cast<Weaponmastery*>(d);
                    foreach (QString w, m_Elements)
                        wm->Weapons.append(Weapon::GetClass(w));
                }else if (name == "Psi-surge"){
                    d->Active = false;
                    // Add also Mindblast:
                    if (!m_Player->HasDiscipline("Mindblast")){
                        Mindblast* m = new Mindblast(m_Player);
                        m->Active = false;
                        m->Serie = 0; // To avoid counting it in GetDisciplineCount
                        m_Player->KaiDisciplines.append(m);
                    }
                }
                m_Player->KaiDisciplines.append(d);
            }
        }
        break;
    default:
        break;
    }

    accept();
}

void BonusDisciplineWindow::RandomSlot()
{
    m_RandomSender = sender()->objectName();
    foreach(QPushButton* b, m_Buttons)
        b->setEnabled(false);
    m_RandomPicker->GetRandomNumber(this);
}

void BonusDisciplineWindow::GetRandomSlot(int random)
{
    if (m_RandomSender == "Weaponskill"){
        KaiDiscipline* d = GetDiscipline(m_RandomSender);
        Weaponskill* ws = qobject_cast<Weaponskill*>(d);
        switch (random){
        case 0:
            ws->Weapon = Weapon::Dagger;
            break;
        case 1:
            ws->Weapon = Weapon::Spear;
            break;
        case 2:
            ws->Weapon = Weapon::Mace;
            break;
        case 3:
            ws->Weapon = Weapon::ShortSword;
            break;
        case 4:
            ws->Weapon = Weapon::WarHammer;
            break;
        case 5:
        case 7:
            ws->Weapon = Weapon::Sword;
            break;
        case 6:
            ws->Weapon = Weapon::Axe;
            break;
        case 8:
            ws->Weapon = Weapon::Quarterstaff;
            break;
        case 9:
            ws->Weapon = Weapon::Broadsword;
            break;
        }
    }
    ShowData();
}

void BonusDisciplineWindow::DiscipleLinkSlot(QString link)
{
    RulesWindow* dlg = new RulesWindow(this, m_Book->BaseDirectory);
    dlg->show();
    dlg->ScrollToAnchor(link);
}

void BonusDisciplineWindow::SelectSlot(bool selected)
{
    if (selected)
        m_Selected++;
    else
        m_Selected--;

    if (selected){
        QString name = sender()->objectName();
        if (name == "Weaponmastery")
            AddWeaponMastery();
    }

    foreach (QCheckBox* c, m_CheckButtons)
        c->setEnabled(m_Selected < m_Number || c->isChecked());
    ui->pbnOk->setEnabled(m_Selected == m_Number);
}

void BonusDisciplineWindow::OkSlot()
{
    CheckWeaponMasteryBonus();
    foreach (QCheckBox* c, m_CheckButtons){
        if (c->isChecked()){
            KaiDiscipline* d = GetDiscipline(c->objectName());
            if (d){
                if (d->Name == "Weaponmastery"){
                    Weaponmastery* wm = qobject_cast<Weaponmastery*>(d);
                    foreach (QString w, m_Elements)
                        wm->Weapons.append(Weapon::GetClass(w));
                }else if (d->Name == "Psi-surge"){
                    d->Active = false;
                    // Add also Mindblast:
                    if (!m_Player->HasDiscipline("Mindblast")){
                        Mindblast* m = new Mindblast(m_Player);
                        m->Active = false;
                        m->Serie = 0; // To avoid counting it in GetDisciplineCount
                        m_Player->KaiDisciplines.append(m);
                    }
                }
                m_Player->KaiDisciplines.append(d);
            }
        }
    }
    accept();
}


void BonusDisciplineWindow::AddWeaponMastery()
{
    QStringList weapons;
    for (int i=Weapon::Dagger; i<=Weapon::Bow; i++)
        weapons.append(Weapon::ClassDescription(i));

    int number = m_Player->GetDisciplineCount() == 0 ? 3 : m_Player->GetDisciplineCount();
    SelectFromListWindow* dlg = new SelectFromListWindow(this, "Select weapons",
                                                         QString("Select %1 weapons for the Weaponmastery discipline").arg(number),
                                                         weapons, number);
    while (dlg->exec() != QDialog::Accepted	){}
    m_Elements = dlg->GetSelected();
}

void BonusDisciplineWindow::CheckWeaponMasteryBonus()
{
    // Check the Weaponmastery discipline to add a weapon:
    if (m_Player->HasDiscipline("Weaponmastery")){
        KaiDiscipline* d = m_Player->GetDiscipline("Weaponmastery");
        Weaponmastery* wm = d != NULL ? qobject_cast<Weaponmastery*>(d) : NULL;

        QStringList weapons;
        for (int i=Weapon::Dagger; i<=Weapon::Bow; i++){
            if (wm == NULL || !wm->Weapons.contains(i))
                weapons.append(Weapon::ClassDescription(i));
        }
        SelectFromListWindow* dlg = new SelectFromListWindow(this, "Select weapons",
                                                             "Select 1 weapon for the Weaponmastery discipline",
                                                             weapons, 1);
        while (dlg->exec() != QDialog::Accepted	){}
        foreach (QString w, dlg->GetSelected())
            wm->Weapons.append(Weapon::GetClass(w));
    }
}
