#ifndef PICKITEMSWINDOW_H
#define PICKITEMSWINDOW_H

#include <QDialog>
#include <QCheckBox>
#include <QMessageBox>
#include "core/player.h"
#include "controls/dialogwindow.h"
#include "randomnumberpicker.h"

namespace Ui {
    class PickItemsWindow;
}

class PickItemsWindow : public DialogWindow
{
    Q_OBJECT

public:
    explicit PickItemsWindow(QWidget *parent = 0, Player* player=0, int serie=Book::Kai, int goldCrowns=0, QList<Item*>* items=0, int max=2);
    ~PickItemsWindow();

    int GetPickedItemsCount() { return m_Selected.count(); }

private:
    Ui::PickItemsWindow *ui;

    QLabel* m_GoldCrownsLabel;
    QPushButton* m_GoldCrownsButton;
    RandomNumberPicker* m_RandomPicker;
    int m_Serie;
    Player* m_Player;
    int m_GoldCrowns;
    QList<Item*>* m_List;
    int m_Max;
    int m_SelectedGoldCrowns;
    QList<Item*> m_Selected;
    QList<QCheckBox*> m_Checkboxes;

    void ShowData(bool full=true);
    bool DropWeapon(Weapon* weapon);
    bool DropItem(Item* item);
    int CountSelectedWeapons();
    int SelectedItemsSize();
    bool HasBackpack();

private slots:
    void CheckItemSlot(bool value);
    void DoneSlot();
    void DropWeapon1Slot();
    void DropWeapon2Slot();
    void DropItemSlot();
    void PickGoldCrownsSlot();
    void RandomSlot(int random);    
};

#endif // PICKITEMSWINDOW_H
