#include "portholeswindow.h"
#include "ui_portholeswindow.h"
#include <QCloseEvent>
#include "commonstatic.h"

PortholesWindow::PortholesWindow(QWidget *parent, Player* player) :
    QMainWindow(parent),
    ui(new Ui::PortholesWindow)
{
    ui->setupUi(this);
#ifndef Q_WS_MAEMO_5
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    CommonStatic::CenterWindow(this);
#endif
#endif

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    m_CanClose = true;
    m_Loop = NULL;
    m_Player = player;

    m_RandomPicker1 = new RandomNumberPicker(this, ui->lblDice1, false);
    m_RandomPicker1->setObjectName("1");
    connect(m_RandomPicker1, SIGNAL(Random(int)), SLOT(RandomSlot(int)));
    m_RandomPicker2 = new RandomNumberPicker(this, ui->lblDice2, false);
    m_RandomPicker2->setObjectName("2");
    connect(m_RandomPicker2, SIGNAL(Random(int)), SLOT(RandomSlot(int)));

    connect(ui->pbnPlay, SIGNAL(clicked()), this, SLOT(PlaySlot()));
    connect(ui->pbnLeave, SIGNAL(clicked()), this, SLOT(close()));
    UpdateData();
}

PortholesWindow::~PortholesWindow()
{
    delete ui;
}

void PortholesWindow::exec()
{
    m_Loop = new QEventLoop(this);
    show();
    m_Loop->exec();
}

void PortholesWindow::closeEvent(QCloseEvent* event)
{
    if (m_CanClose){
        if (m_Loop)
            m_Loop->quit();
        event->accept();
    }else{
        event->ignore();
    }
}

void PortholesWindow::RandomSlot(int random)
{
    if(sender()->objectName() == "1")
        m_Random1 = random;
    else if(sender()->objectName() == "2")
        m_Random2 = random;

    if (m_Random1 >= 0 && m_Random2 >= 0){
        switch(m_CurrentPlayer){
        case 0:
            ui->lblPlayer1->setText(QString::number(m_Random1 + m_Random2));
            if (m_Random1 + m_Random2 == 0)
                Evaluate();
            else
                Play(1);
            break;
        case 1:
            ui->lblPlayer2->setText(QString::number(m_Random1 + m_Random2));
            if (m_Random1 + m_Random2 == 0)
                Evaluate();
            else
                Play(2);
            break;
        case 2:
            ui->lblLoneWolf->setText(QString::number(m_Random1 + m_Random2));
            Evaluate();
            break;
        }
    }
}

void PortholesWindow::UpdateData()
{
    ui->lblGoldCrowns->setText(QString::number(m_Player->GetGoldCrowns()));
    if (m_Player->GetGoldCrowns() < 3 || m_Player->GetGoldCrowns() == 50)
        ui->pbnPlay->setEnabled(false);
}

void PortholesWindow::Play(int player)
{
    m_CurrentPlayer = player;
    m_Random1 = -1;
    m_Random2 = -1;
    switch(m_CurrentPlayer){
    case 0:
        ui->lblPlayer->setText("Player 1");
        break;
    case 1:
        ui->lblPlayer->setText("Player 2");
        break;
    case 2:
        ui->lblPlayer->setText("Lone Wolf");
        break;
    }
    m_RandomPicker1->GetRandomNumber(NULL);
    m_RandomPicker2->GetRandomNumber(NULL);
}

void PortholesWindow::PlaySlot()
{
    m_CanClose = false;
    ui->lblMessage->clear();
    ui->lblPlayer1->setText("-");
    ui->lblPlayer2->setText("-");
    ui->lblLoneWolf->setText("-");
    Play(0);
}

void PortholesWindow::Evaluate()
{
    int p1 = ui->lblPlayer1->text() == "-" ? -1 : ui->lblPlayer1->text().toInt();
    int p2 = ui->lblPlayer2->text() == "-" ? -1 : ui->lblPlayer2->text().toInt();
    int lw = ui->lblLoneWolf->text() == "-" ? -1 : ui->lblLoneWolf->text().toInt();

    if (p1 == 0 || p2 == 0){
        ui->lblMessage->setText("Portholes! You lose 3 Gold Crowns.");
        m_Player->SetGoldCrowns(m_Player->GetGoldCrowns() - 3);
    }else if (lw ==0){
        ui->lblMessage->setText("Portholes! You win 6 Gold Crowns.");
        m_Player->SetGoldCrowns(m_Player->GetGoldCrowns() + 6);
    }else if ((p1 > lw || p2 > lw) && p1 != p2){
        ui->lblMessage->setText("You lose 3 Gold Crowns.");
        m_Player->SetGoldCrowns(m_Player->GetGoldCrowns() - 3);
    }else if (lw > p1 && lw > p2){
        ui->lblMessage->setText("You win 6 Gold Crowns.");
        m_Player->SetGoldCrowns(m_Player->GetGoldCrowns() + 6);
    }else{
        ui->lblMessage->setText("Draw.");
    }

    UpdateData();
    m_CanClose = true;
}
