#ifndef ITEM_H
#define ITEM_H

#include <QObject>
#include <QHash>
#include <QScriptEngine>

class PropertiesItem : public QObject
{
    Q_OBJECT

public:
    explicit PropertiesItem(QObject *parent = 0);
    PropertiesItem(const PropertiesItem& item);

    QHash<QString, QString> Properties;

public slots:
    bool HasProperty(QString name) { return Properties.contains(name); }
    QString GetProperty(QString name);
    void SetProperty(QString name, QString value);
    bool GetBoolProperty(QString name) { return GetProperty(name).toInt() == 1;}
    void SetBoolProperty(QString name, bool value) { SetProperty(name, value ? "1" : "0"); }
};



class Item : public PropertiesItem
{
    Q_OBJECT
public:
    explicit Item(QObject *parent = 0);
    Item(const Item& item);

    QString Name;
    QString Description;

    bool IsUsable() { return GetIsMeal() || GetEnduranceRestore() || GetCombatskillDelta(); }
    void Use(QScriptEngine* engine, QScriptValue* functions);

public slots:
    QString GetName() { return Name; }

    bool GetIsBackpackItem() { return !GetIsSpecial() && !GetIsWeapon(); }

    bool GetIsSpecial() { return GetBoolProperty("IsSpecial"); }
    void SetIsSpecial(bool value) { SetBoolProperty("IsSpecial", value); }

    bool GetIsBackpack() { return GetBoolProperty("IsBackpack"); }
    void SetIsBackpack(bool value) { SetBoolProperty("IsBackpack", value); }

    bool GetIsQuiver() { return GetBoolProperty("IsQuiver"); }
    void SetIsQuiver(bool value) { SetBoolProperty("IsQuiver", value); }

    int GetArrows() { return GetProperty("Arrows").toInt(); }
    void SetArrows(int value) { SetProperty("Arrows", QString::number(value)); }

    bool GetIsMeal() { return GetBoolProperty("IsMeal"); }
    void SetIsMeal(bool value) { SetBoolProperty("IsMeal", value); }

    int GetEnduranceRestore() { return GetProperty("EnduranceRestore").toInt(); }
    void SetEnduranceRestore(int value) { SetProperty("EnduranceRestore", QString::number(value)); }

    int GetEnduranceDelta() { return GetProperty("EnduranceDelta").toInt(); }
    void SetEnduranceDelta(int value) { SetProperty("EnduranceDelta", QString::number(value)); }

    QString GetDescription();
    void SetDescription(QString value) { Description = value; }

    int GetCombatskillDelta() { return GetProperty("CombatskillDelta").toInt(); }
    void SetCombatskillDelta(int value) { SetProperty("CombatskillDelta", QString::number(value)); }

    int GetQuantity() { return GetProperty("Quantity").toInt(); }
    void SetQuantity(int value) { SetProperty("Quantity", QString::number(value)); }

    int GetSize() { return GetProperty("Size").toInt(); }
    void SetSize(int value) { SetProperty("Size", QString::number(value)); }

    bool GetIsEquipped() { return GetBoolProperty("IsEquipped"); }
    void SetIsEquipped(bool value) { SetBoolProperty("IsEquipped", value); }
    void Equip() { if (GetCanBeEquipped()) SetIsEquipped(true); }
    void Unequip() { SetIsEquipped(false); }

    bool GetIsArrow() { return GetBoolProperty("IsArrow"); }
    void SetIsArrow(bool value) { SetBoolProperty("IsArrow", value); }

    bool GetIsWeapon() { return GetBoolProperty("IsWeapon"); }
    void SetIsWeapon(bool value) { SetBoolProperty("IsWeapon", value); }

    bool GetCanBeEquipped();
    void SetCanBeEquipped(bool value);

    bool GetIsArmor() { return GetBoolProperty("IsArmor"); }
    void SetIsArmor(bool value) { SetBoolProperty("IsArmor", value); }

    int GetHands() { return GetProperty("Hands").toInt(); }
    void SetHands(int value) { SetProperty("Hands", QString::number(value)); }

    int GetArmorClass() { return GetProperty("Class").toInt(); }
    void SetArmorClass(int value) { SetProperty("Class", QString::number(value)); }

    int GetRandomBonus() { return GetProperty("RandomBonus").toInt(); }
    void SetRandomBonus(int value) { SetProperty("RandomBonus", QString::number(value)); }
};

class Weapon : public Item
{
    Q_OBJECT
public:
    enum WeaponsClass
    {
       None = -1,
       Dagger,
       Spear,
       Mace,
       ShortSword,
       WarHammer,
       Axe,
       Sword,
       Quarterstaff,
       Broadsword,
       Bow
    };

    explicit Weapon(QObject *parent = 0);
    Weapon(const Weapon& weapon);

    static QString ClassDescription(int Class);
    static int GetClass(QString);

public slots:
    QList<int> Classes();
    void AddClass(int iClass);
};

class ShopItem : public Weapon
{
    Q_OBJECT
public:
    explicit ShopItem(QObject *parent = 0);

    int Price;
    int SellPrice;
    bool UnlimitedQuantity;

    bool IsWeapon() { return Classes().count() > 0; }
};

class Armor : public Item
{
    Q_OBJECT
public:
    enum ArmorClass
    {
       None = -1,
       Head,
       Body,
       Hand
    };

    explicit Armor(QObject *parent = 0);
    Armor(const Armor& armor);

    static int GetClass(QString);

public slots:
    int GetClass();
    void SetClass(int iClass);
};

#endif // ITEM_H
