#ifndef PLAYER_H
#define PLAYER_H

#include <QObject>
#include "kaidiscipline.h"
#include "book.h"

class Player : public QObject
{
    Q_OBJECT
public:
    explicit Player(QObject *parent = 0);
    Player(const Player& player);

    int BaseCombatSkill;
    int BaseEndurance;
    int Endurance;

    int Arrows;
    int GoldCrowns;
    int TemporaryCombatSkillDelta;


    int GetCombatSkill();
    int GetCombatSkill(Enemy*);

    QList<KaiDiscipline*> KaiDisciplines;
    void RemoveDiscipline(QString name);

    QList<Weapon*> Weapons();
    QList<Item*> BackpackItems();
    QList<Item*> SpecialItems();
    QList<Item*> Items;
    QList<Item*> HiddenItems;

    int DeathsCount;

    static QString GetRankDescription(int serie, int kaiDisciplinesCount);
    QHash<QString, QString> Properties;
    void CheckEndurance();
    void Dump();
    KaiDiscipline* GetDiscipline(QString name);

private:
    bool m_Backpack;
    bool m_CanHunt;
    bool m_Quiver;

public slots:
    // Remove all disciplines (used at the beginning of a new serie when disciplines change)
    void RemoveDisciplines();

    // Return true if the player is dead
    bool IsDead();

    // Clear all the player's properties
    void ClearProperties();
    // Get a player property
    QString GetProperty(QString name);
    // Set a player property
    void SetProperty(QString name, QString value);
    // Remove a property
    void RemoveProperty(QString name);

    // Return true if the player has learned the discipline
    bool HasDiscipline(QString name);
    // Return true if the player has complete the lore circle
    bool HasLoreCircle(QString name);
    // Return the number of discipline the player has learned
    int GetDisciplineCount();
    // Return true if the player has the Weaponskill in a weapon class
    bool HasWeaponskillIn(QString className);
    // Return true if the player has the Weaponmastery in a weapon class
    bool HasWeaponmasteryIn(QString className);
    // Return true if the player has a bonus due to the Weaponskill (check equipped weapon)
    bool HasWeaponskillBonus();
    // Return the player's base endurance (the max value)
    int GetBaseEndurance();
    // Return the player's current endurance
    int GetEndurance();
    // Set the player's current endurance
    void SetEndurance(int);
    // Set the player's current endurance without check on base endurance
    void ForceEndurance(int);
    // Return the player's base combat skill
    int GetBaseCombatSkill();
    // Set the player's current endurance
    void SetBaseCombatSkill(int);
    // Set the player's temporary combat skill delta.
    // It will be set to 0 after a combat or when leaving a section
    void SetTempCombatSkillDelta(int);

    bool HasItem(QString name);
    bool HasSpecialItem(QString name);
    Item* AddItem(QString name, bool special);
    // Remove one item from the player, returns true if the item has been removed
    bool RemoveItem(QString name);
    // Return one item from the player
    Item* GetItem(QString name);

    Item* AddMeal(QString name);
    Item* AddHealingItem(QString name, int enduranceRestore);

    int GetArrows() { return Arrows; }
    void SetArrows(int value) { value <= 6 ? Arrows = value : Arrows = 6; }

    int GetGoldCrowns();
    void SetGoldCrowns(int);

    // Return the number of special items
    int SpecialItemsCount();
    // Return the number of backpack items
    int ItemsCount();
    // Return the number of meals
    int MealsCount();
    QStringList GetSpecialItems();
    QStringList GetItems();

    // Hides an item from the inventory
    bool HideItem(QString name);
    // Restore a hidden item to the inventory
    bool RestoreHiddenItem(QString name);
    // Get the list of hidden items
    QStringList GetHiddenItems();

    bool CanHunt() const { return m_CanHunt; }
    void SetCanHunt(bool value) { m_CanHunt = value; }

    bool HasBackpack() const { return m_Backpack; }
    void SetHasBackpack(bool value);
    bool IsBackpackFull();
    int GetBackpackFreeSpace();

    bool HasQuiver() const { return m_Quiver; }
    void SetHasQuiver(bool value);
    int GetBowBonus(bool includeDisciplines=true);

    int WeaponsCount();
    QStringList GetWeapons();
    Weapon* GetEquippedWeapon();
    void RemoveWeapon(QString name);
    Weapon* AddWeapon(QString name, QString classname);
    Weapon* AddSpecialWeapon(QString name, QString classname);
    bool HasWeapon(QString name);
    Weapon* GetWeapon(QString name);
    int GetFreeHands();

    bool IsEquipped(QString name);
    void Equip(QString name);
};

#endif // PLAYER_H
