#include "bookswindow.h"
#include "ui_bookswindow.h"
#include <QPushButton>
#include "bookwindow.h"
#ifdef Q_WS_MAEMO_5
#include <QMaemo5Style>
#endif
#include "downloadwindow.h"
#include "aonlicensewindow.h"
#include "commonstatic.h"

BooksWindow::BooksWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::BooksWindow)
{
    ui->setupUi(this);
#ifndef Q_WS_MAEMO_5
#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    CommonStatic::CenterWindow(this);
#endif
#endif

#ifdef Q_OS_SYMBIAN
    QAction* backSoftKey = new QAction( tr("Back"), this );
    backSoftKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(backSoftKey, SIGNAL(triggered()), this, SLOT(accept()));
    addAction(backSoftKey);
#endif

    setAttribute(Qt::WA_DeleteOnClose);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation);
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    if (CommonStatic::GeneralSettings(this)->value("license", false).toBool()){
        ui->pbnLicense->setVisible(false);
        ui->lblMessage->setText("Books are downloaded from the <a href=\"http://www.projectaon.org/en/Main/Home\">Project AON</a> website\
                                under the <a href=\"http://www.projectaon.org/en/Main/License\">AON License.</a>");
    }else{
        ui->lblMessage->setText("Books are downloaded from the <a href=\"http://www.projectaon.org/en/Main/Home\">Project AON</a> website. <br>\
                                To downlad the books, you must accept the <a href=\"http://www.projectaon.org/en/Main/License\">AON License</a>.");
    }
    connect(ui->pbnLicense, SIGNAL(clicked()), this, SLOT(LicenseSlot()));
    connect(ui->pbnUpdate, SIGNAL(clicked()), this, SLOT(UpdateSlot()));
    m_Books = new Books(this);
    m_Books->LoadList();
    BuildList();
}

BooksWindow::~BooksWindow()
{
    delete ui;
}

void BooksWindow::BuildList()
{
    QLayoutItem* child;
    while ((child = ui->layBooks->takeAt(0)) != 0) {
        delete child->widget();
        delete child;
    }

    int row = 0;
    QSizePolicy stretchZero;
    stretchZero.setHorizontalStretch(0);

#ifdef Q_WS_MAEMO_5
    QColor secondaryColor = QMaemo5Style::standardColor("SecondaryTextColor");
    QPalette secondaryPalette(QColor(255,255,255, 0));
    secondaryPalette.setColor(QPalette::Foreground, secondaryColor);
#endif

    QString oldSection = "";

    int index = 0;
    foreach(BookEntry* b, m_Books->List){
        if (oldSection.isEmpty() || oldSection != b->Serie){
            QLabel* slbl = new QLabel(this);
            slbl->setText(QString("<b>%1</b>").arg(b->Serie));
            slbl->setWordWrap(true);
#ifdef Q_WS_MAEMO_5
            slbl->setPalette(secondaryPalette);
#endif
            ui->layBooks->addWidget(slbl, row, 0, 1, 3);
            row++;

            oldSection = b->Serie;
        }

        QLabel* lbl = new QLabel(this);
        lbl->setSizePolicy(stretchZero);
        lbl->setText(QString("<b>%1:</b>").arg(b->Number));
        ui->layBooks->addWidget(lbl, row, 0);

        lbl = new QLabel(this);
        lbl->setText(b->Title);
        lbl->setWordWrap(true);
        ui->layBooks->addWidget(lbl, row, 1);

        if (b->Available){
            QPushButton* pbn = new QPushButton(this);
            pbn->setObjectName(QString::number(index));
            pbn->setText("Download");
#ifdef Q_WS_MAEMO_5
            pbn->setMaximumHeight(50);
            pbn->setSizePolicy(stretchZero);
#else
            pbn->setMaximumSize(75, 50);
#endif
            connect(pbn, SIGNAL(clicked()), this, SLOT(DownloadSlot()));
            ui->layBooks->addWidget(pbn, row, 2);

            if (QFile::exists(Books::GetBookFilename(b->Number))){
                Book* book = new Book(this);
                book->Load(Books::GetBookFilename(b->Number), false);
                if (book->Version < b->Version || (book->Version == b->Version && book->Revision < b->Revision)){
                    pbn->setText("Update");
                }else{
                    pbn->setEnabled(false);
                }
                delete book;
            }
        }else{
            lbl = new QLabel(this);
            lbl->setText("Not available");
            lbl->setWordWrap(false);
            lbl->setAlignment(Qt::AlignRight | Qt::AlignHCenter);
            ui->layBooks->addWidget(lbl, row, 2);
        }
        row++;
        index++;
    }
}

void BooksWindow::DownloadSlot()
{
    if (!CommonStatic::GeneralSettings(this)->value("license", false).toBool()){
        LicenseSlot();
        if (!CommonStatic::GeneralSettings(this)->value("license", false).toBool())
            return;
    }

    QPushButton* pbn = (QPushButton*)sender();
    BookEntry* book = m_Books->List.at(pbn->objectName().toInt());
    DownloadWindow* dlg = new DownloadWindow(this, book);
    if (dlg->exec() == QDialog::Accepted){
        m_Books->LoadList();
        BuildList();
    }
}

void BooksWindow::LicenseSlot()
{
    AonLicenseWindow* dlg = new AonLicenseWindow(this);
    if (dlg->exec() == QDialog::Accepted){
        ui->pbnLicense->setVisible(false);
        QSettings* settings = CommonStatic::GeneralSettings(this);
        settings->setValue("license", true);
        settings->sync();
    }
    delete dlg;
}

void BooksWindow::UpdateSlot()
{
    DownloadWindow* dlg = new DownloadWindow(this, NULL, m_Books->DownloadUrl, QString("%1/books.xml").arg(Books::Directory()));
    if (dlg->exec() == QDialog::Accepted){
        m_Books->LoadList();
        BuildList();
    }
}
