#include <QtGui/QApplication>
#include <QSettings>
#include <QDir>

#include "mainwindow.h"
#include "core/books.h"

#define QUOTE_(x) #x
#define QUOTE(x) QUOTE_(x)

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    a.setOrganizationName("sakya");
    a.setApplicationName("LoneWolf");
    a.setApplicationVersion(QUOTE(APP_VERSION));
    a.setQuitOnLastWindowClosed(false);

#if defined(Q_OS_WIN) || defined(Q_OS_WINCE) || defined(Q_OS_LINUX) || defined (Q_OS_MACX)
    QString booksDir = Books::Directory();
    if (!QDir().exists(booksDir))
        QDir().mkpath(booksDir);
#endif

    QSettings::setDefaultFormat(QSettings::IniFormat);
    MainWindow w;
#if defined(Q_WS_S60)
    w.showMaximized();
#else
    w.show();
#endif

    return a.exec();
}
