#include "books.h"
#include <QtXml>
#include <QDesktopServices>

BookEntry::BookEntry(QObject *parent) :
    QObject(parent)
{
    Serie = "";
    Title = "";
    Number = 0;
    Downloaded = false;
    Version = 0;
    Revision = 0;
}

Books::Books(QObject *parent) :
    QObject(parent)
{

}

QString Books::BaseUrl()
{
    return "http://www.projectaon.org/staff/paolo/";
}

QString Books::Directory()
{
#ifdef Q_WS_MAEMO_5
    return "/opt/lonewolf/books";
#else
#ifdef QT_NO_DEBUG
    return QString("%1/books").arg(QDesktopServices::storageLocation(QDesktopServices::DataLocation));
#else
    return "g:/Sviluppo/LoneWolf/Books";
#endif
#endif
}

QString Books::GetBookFilename(int number)
{
    QString num = QString::number(number);
    num = num.rightJustified(2, '0');
    return QString("%1/%2/%2.xml").arg(Directory()).arg(num);
}

bool Books::LoadList()
{
    List.clear();
    DownloadUrl = QString("%1books.xml").arg(BaseUrl());

    QDomDocument doc("books");
    QFile file(QString("%1/books.xml").arg(Directory()));
    if(!file.open(QIODevice::ReadOnly))
        return false;

    if(!doc.setContent(&file)) {
        file.close();
        return false;
    }
    file.close();

    QDomElement root = doc.documentElement();
    if( root.tagName() != "books" )
        return false;

    Version = root.attribute("version", "").toInt();
    DownloadUrl = root.attribute("url", "");
    if (DownloadUrl.isEmpty())
        DownloadUrl = QString("%1books.xml").arg(BaseUrl());

    QDomNode n = root.firstChild();
    while( !n.isNull() ) {
        QDomElement e = n.toElement();
        if(!e.isNull()){
            if(e.tagName() == "book"){
                BookEntry* b = new BookEntry(this);
                b->Serie = e.attribute("serie", "");
                b->Title = e.attribute("title", "");
                b->Version = e.attribute("version", "").toInt();
                b->Revision = e.attribute("revision", "").toInt();
                b->Number = e.attribute("number", "").toInt();
                b->Available = e.attribute("available", "").toInt() == 1;
                b->DownloadUrl = e.attribute("url", "");
                if (b->DownloadUrl.isEmpty())
                    b->DownloadUrl = QString("%1book_%2.zip").arg(BaseUrl()).arg(b->Number, 2, 10, QLatin1Char('0'));
                List.append(b);
            }
        }
        n = n.nextSibling();
    }
    return true;
}
