#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QStringList>
#include <QXmlStreamReader>
#include <QDebug>
#include <QWidget>

#include "tubeapi.h"

struct TubeApiPrivate {
	QStringList results;
	QImage result2;
	QUrl apiUrl;
	QNetworkAccessManager *manager;
	int maxItems;
};

TubeApi::TubeApi( QObject *parent )
        : QObject( parent )
{
	d = new TubeApiPrivate;
	d->apiUrl = QUrl("http://api.tubeupdates.com/?method=get.status");
	d->manager = new QNetworkAccessManager( this );
	connect( d->manager, SIGNAL(finished(QNetworkReply*)), SLOT(finished(QNetworkReply *)) );
}

TubeApi::~TubeApi()
{
	delete d;
}

QStringList TubeApi::results() const
{
	return d->results;
}

void TubeApi::search( const QString &searchTube )
{
	QUrl url = d->apiUrl;
	url.addQueryItem( QString("lines"), searchTube );
	url.addQueryItem( QString("format"), QString("xml") );

	//qDebug() << "Constructed search URL" << url;

	d->manager->get( QNetworkRequest(url) );
}

void TubeApi::finished( QNetworkReply *reply )
{
	if ( reply->error() != QNetworkReply::NoError ) {
		//qDebug() << "Request failed, " << reply->errorString();
		emit finished(false);
		return;
	}

	//qDebug() << "Request succeeded";
	bool ok = processApiResult( reply );
	emit finished( ok );
}

bool TubeApi::processApiResult( QIODevice *source )
{
	d->results.clear();

	QXmlStreamReader reader( source );
	QString currId;
	QString line1;
	while ( !reader.atEnd() ) 
	{
		QXmlStreamReader::TokenType tokenType = reader.readNext();
		//qDebug() << "Token" << int(tokenType);
		//qDebug() << "Token: " << reader.tokenString() << "Name : " << reader.name();
		if ( tokenType == QXmlStreamReader::StartElement && (reader.name() == "id" || reader.name() == "status") )
		{
			if ( reader.name() == "id" )
			{
				reader.readNext();
				currId = reader.text().toString();
				line1 += currId;
			}
			else  // status
			{
				reader.readNext();
				line1 += " has " + reader.text().toString();
				d->results << line1;
				line1.clear();
			}
		}
		else if ( tokenType == QXmlStreamReader::StartElement && reader.name() == "messages" )
		{
			reader.readNext();
			QString line2;
			while(tokenType != QXmlStreamReader::EndElement && reader.name() != "messages")
			{
				if ( tokenType == QXmlStreamReader::StartElement && reader.name() == "message" )
				{
					reader.readNext();
					//qDebug() << "Data: " << reader.text();
					line2 += reader.text().toString();
				}
				reader.readNext();
			}
			d->results << line2;
		}

	}

	//qDebug() << "Results" << d->results;
	return true;
}
