#include <glib.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>
#include <stdio.h>

static gboolean send_ping (DBusConnection *bus);

int main (int argc, char **argv)
{

	GMainLoop *loop;
	DBusConnection *bus;
	DBusError error;

	loop = g_main_loop_new (NULL, FALSE);
	dbus_error_init (&error);
	bus = dbus_bus_get (DBUS_BUS_SYSTEM, &error);

	if (!bus) 
	{
		g_warning ("Failed to connect to the D-BUS daemon: %s", error.message);
  		dbus_error_free (&error);
		return 1;
	}
	dbus_connection_setup_with_g_main (bus, NULL);
	send_ping(bus);
	return 0;
}

static gboolean send_ping (DBusConnection *bus)
{
	DBusMessage *message;
    	message = dbus_message_new_signal ("/hopbeat/lockDaemon",
			     			    "hopbeat.lockDaemon", "Switch");

	const char *v_STRING = "Ping!";
	dbus_message_append_args (message,
			DBUS_TYPE_STRING, &v_STRING,
			DBUS_TYPE_INVALID);
	dbus_connection_send (bus, message, NULL);
	dbus_message_unref (message);
	g_print("Done\n");
	return TRUE;
}
