#include <handler.h>



Handler::Handler(QWidget* window_,QApplication* app_):window(window_),app(app_)
{


	readConfig();
	


	 
	keyboardSound = new QCheckBox("Keyboard sound");
	keyboardSound->setCheckState(ks ? Qt::Checked : Qt::Unchecked);
	lockSound = new QCheckBox("Lock sound");
	lockSound->setCheckState(ls ? Qt::Checked : Qt::Unchecked);
	keyboardVibration = new QCheckBox("Keyboard Vibration");
	keyboardVibration->setCheckState(kv ? Qt::Checked : Qt::Unchecked);
	lockVibration = new QCheckBox("Lock Vibration");
	lockVibration->setCheckState(lv ? Qt::Checked : Qt::Unchecked);

				 
	kso=new QLabel(QString("Keyboard open sound"));
	ksc=new QLabel(QString("Keyboard close sound"));
	
	ksob=new QPushButton(QString(ksos.substr(ksos.find_last_of("/")+1,ksos.length()).c_str()));
	kscb=new QPushButton(QString(kscs.substr(kscs.find_last_of("/")+1,kscs.length()).c_str()));
	lso=new QLabel(QString("Lock sound"));
	lsc=new QLabel(QString("Unlock sound"));
				 
	done=new QPushButton(QString("Done"));
				 
	lsob=new QPushButton(QString(lsos.substr(lsos.find_last_of("/")+1,lsos.length()).c_str()));
	lscb=new QPushButton(QString(lscs.substr(lscs.find_last_of("/")+1,lscs.length()).c_str()));

	 layout = new QGridLayout;
 	 layout->addWidget(keyboardSound,0,0);
	 layout->addWidget(kso,1,0);
	 layout->addWidget(ksob,1,1);
	 layout->addWidget(ksc,2,0);
	 layout->addWidget(kscb,2,1);
	 layout->addWidget(lockSound,3,0);
	 layout->addWidget(lso,4,0);
	 layout->addWidget(lsob,4,1);
	 layout->addWidget(lsc,5,0);
	 layout->addWidget(lscb,5,1);
	 layout->addWidget(keyboardVibration,6,0);
	 layout->addWidget(lockVibration,6,1);
	 layout->addWidget(done,7,0,1,2);
							

	QObject::connect(keyboardSound,SIGNAL(stateChanged(int)),this,SLOT(keyboardSoundChanged(int)));	
	QObject::connect(lockSound,SIGNAL(stateChanged(int)),this,SLOT(lockSoundChanged(int)));	
	QObject::connect(ksob,SIGNAL(clicked()),this,SLOT(keyboardOpenClicked()));	
	QObject::connect(kscb,SIGNAL(clicked()),this,SLOT(keyboardClosedClicked()));	
	QObject::connect(lsob,SIGNAL(clicked()),this,SLOT(lockOpenClicked()));	
	QObject::connect(lscb,SIGNAL(clicked()),this,SLOT(lockClosedClicked()));	
	QObject::connect(done,SIGNAL(clicked()),this,SLOT(doneSlot()));	
	
	QObject::connect(keyboardVibration,SIGNAL(stateChanged(int)),this,SLOT(keyboardVibChanged(int)));	
	QObject::connect(lockVibration,SIGNAL(stateChanged(int)),this,SLOT(lockVibChanged(int)));	
	
	keyboardSoundChanged(ks ? Qt::Checked : Qt::Unchecked);
	lockSoundChanged(ls ? Qt::Checked : Qt::Unchecked);
	keyboardVibChanged(kv ? Qt::Checked : Qt::Unchecked);
	lockVibChanged(lv ? Qt::Checked : Qt::Unchecked);
				                                                                     

}


void Handler::keyboardSoundChanged(int state)
{
	std::cout<<state<<std::endl;
	if (state==0)
	{
		ks=0;
		
		kso->hide();
		ksc->hide();
		ksob->hide();
		kscb->hide();
	}
	else if (state==2)
	{
		ks=1;

		kso->show();
		ksc->show();
		ksob->show();
		kscb->show();


	}
}

void Handler::lockSoundChanged(int state)
{
	std::cout<<state<<std::endl;
	if (state==0)
	{
		ls=0;
		
		lso->hide();
		lsc->hide();
		lsob->hide();
		lscb->hide();
	}
	else if (state==2)
	{
		ls=1;

		lso->show();
		lsc->show();
		lsob->show();
		lscb->show();


	}
}

void Handler::keyboardOpenClicked()
{


				 
  	QString fileName = QFileDialog::getOpenFileName(NULL, "Open sound", "/home/user/MyDocs/.sounds/", "Sound Files (*.mp3 *.wav *.ogg *.txt)");
				
	std::cout<<"####"<<fileName.toStdString()<<"&&&&"<<std::endl;
				 
	if (!fileName.compare("")==0)
	{
		std::cout<<fileName.toStdString()<<std::endl;
		ksos=fileName.toStdString();
		ksob->setText(QString(ksos.substr(ksos.find_last_of("/")+1,ksos.length()).c_str()));
	}
	
}

void Handler::keyboardClosedClicked()
{


				 
  	QString fileName = QFileDialog::getOpenFileName(NULL, "Open sound", "/home/user/MyDocs/.sounds/", "Sound Files (*.mp3 *.wav *.ogg *.txt)");
				
	std::cout<<"####"<<fileName.toStdString()<<"&&&&"<<std::endl;
				 
	if (!fileName.compare("")==0)
	{
		std::cout<<fileName.toStdString()<<std::endl;
		kscs=fileName.toStdString();
		kscb->setText(QString(kscs.substr(kscs.find_last_of("/")+1,kscs.length()).c_str()));
	}
	
}


void Handler::lockOpenClicked()
{


				 
  	QString fileName = QFileDialog::getOpenFileName(NULL, "Open sound", "/home/user/MyDocs/.sounds/", "Sound Files (*.mp3 *.wav *.ogg *.txt)");
				
	std::cout<<"####"<<fileName.toStdString()<<"&&&&"<<std::endl;
				 
	if (!fileName.compare("")==0)
	{
		std::cout<<fileName.toStdString()<<std::endl;
		lsos=fileName.toStdString();
		lsob->setText(QString(lsos.substr(lsos.find_last_of("/")+1,lsos.length()).c_str()));
	}
	
}

void Handler::lockClosedClicked()
{


				 
  	QString fileName = QFileDialog::getOpenFileName(NULL, "Open sound", "/home/user/MyDocs/.sounds/", "Sound Files (*.mp3 *.wav *.ogg *.txt)");
				
	std::cout<<"####"<<fileName.toStdString()<<"&&&&"<<std::endl;
				 
	if (!fileName.compare("")==0)
	{
		std::cout<<fileName.toStdString()<<std::endl;
		lscs=fileName.toStdString();
		lscb->setText(QString(lscs.substr(lscs.find_last_of("/")+1,lscs.length()).c_str()));
	}
	
}

void Handler::lockVibChanged(int state)
{
	if (state==0)
	{
		lv=0;
	}

	else if (state==2)
	{
		lv=1;
	}

}

void Handler::keyboardVibChanged(int state)
{
	if (state==0)
	{
		kv=0;
	}

	else if (state==2)
	{
		kv=1;
	}

}


void Handler::readConfig()
{
	std::string line;
        std::ifstream myfile ("/home/opt/lockdaemon/lockdaemon.conf");
        
	if (myfile.is_open())
        {
                int i=0;
                while (! myfile.eof() )
                {
                        getline (myfile,line);
                        if (i==0)
                        {
				kv=QString(line.c_str()).toInt();
                        }
                        else if (i==1)
                        {
				lv=QString(line.c_str()).toInt();
                        }
                        else if (i==2)
                        {
				ks=QString(line.c_str()).toInt();
				std::cout<<"here "<<ks<<std::endl;
                        }
                        else if (i==3)
                        {
				ls=QString(line.c_str()).toInt();
                        }
                        else if (i==4)
                        {
				ksos=line.c_str();
                        }
                        else if (i==5)
                        {
				kscs=line.c_str();
                        }
                        else if (i==6)
                        {
				lsos=line.c_str();
                        }
                        else if (i==7)
                        {
				lscs=line.c_str();
                        }
                        ++i;
			std::cout << line << std::endl;
                }
                myfile.close();
        }
        else std::cout << "Unable to open file";


}

void Handler::writeConfig()
{

	std::cout<<"writing config"<<std::endl;
	std::ofstream myfile ("/home/opt/lockdaemon/lockdaemon.conf");
       	if (myfile.is_open())
	  {
	
  		  myfile << kv;
		  myfile << "\n";
  		  
		  myfile << lv;
		  myfile << "\n";
		  
  		  myfile << ks;
		  myfile << "\n";
  		  
		  myfile << ls;
		  myfile << "\n";
  		  
		  myfile << ksos;
		  myfile << "\n";
  		  
		  myfile << kscs;
		  myfile << "\n";
		  
  		  myfile << lsos;
		  myfile << "\n";
  		  
		  myfile << lscs;
		  myfile << "\n";

		  myfile.close();

	  }

    	else std::cout << "Unable to open file";

}


void Handler::doneSlot()
{
	//QMaemo5InformationBox::information(0, "Restarting lockdaemon",QMaemo5InformationBox::DefaultTimeout);
	writeConfig();
	system("killall lockdaemon");
	app->quit();
}	
