#!/usr/bin/python2.5

##############################################################
##   CellID to Geolocation using google's APIs              ##
##############################################################
# Copyright (c) 2011 Christos Zamantzas
# Licenced under GPLv2

#Author: Christos Zamantzas <christos.zamantzas@gmail.com>
Version = '0.1-1'

# get cellid codes via dbus command
    # MCC:	Mobile Country Code;	
    # MNC:	Mobile Network Code;
    # LAC:	Local Area Code; 	
    # CELLID:	Cellid;

from struct import pack, unpack
from httplib import HTTP
import urllib2
import urllib
import os
import sys

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtMaemo5 import *

from locatefromcellUI import *

country         = "en"
device          = "Nokia-N900-M5"
user_agent      = 'Mozilla/4.0 (compatible; MSIE 5.5; Windows NT)'
url_mmap        = 'http://www.google.com/glm/mmap'
url_geo         = 'http://maps.google.com/maps/geo'
url_map         = 'http://maps.google.com/maps'

dbus_browser    = 'dbus-send --system --type=method_call\
                            --dest="com.nokia.osso_browser"\
                            --print-reply /com/nokia/osso_browser/request\
                            com.nokia.osso_browser.load_url string:'
dbus_cellid     = 'dbus-send --system --print-reply=literal\
                            --type=method_call\
                            --dest=com.nokia.phone.net\
                            /com/nokia/phone/net Phone.Net.get_registration_status'
LogPath         = '/home/user/.locatefromcell'
MapName         = 'map.png'

def checkFile(Path, File):       
    ''' Check if a file exists. '''

    try:
        f = open(Path + File, 'r')
        f.close()
    except:
        return False
    else:
        return True

def showMessage(message):        
    ''' Method to display a message to the user that waits for an action. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications \
               org.freedesktop.Notifications.SystemNoteDialog \
               string:"%s" uint32:0 string:"OK"' % message)          

def showQuickMessage(message):   
    ''' Method to display shortly a message to the user. '''

    os.system('dbus-send --type=method_call --dest=org.freedesktop.Notifications \
               /org/freedesktop/Notifications \
               org.freedesktop.Notifications.SystemNoteInfoprint \
               string:"%s"' % message)          
               
class LocateFromCellAbout(QtGui.QMainWindow): #FIXME: update info, icon, URLs
    '''About Window'''
    def __init__(self, parent=None):
        QMainWindow.__init__(self,parent)
        self.parent = parent
        self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
        self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
        self.setWindowTitle("About Locate From Cell")

        aboutScrollArea = QScrollArea(self)
        aboutScrollArea.setWidgetResizable(True)
        awidget = QWidget(aboutScrollArea)
        awidget.setMinimumSize(470,1000)
        awidget.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
        aboutScrollArea.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
        #Kinetic scroller is available on Maemo and should be on meego
        try:
            scroller = aboutScrollArea.property("kineticScroller").toPyObject()
            scroller.setEnabled(True)
        except:
            pass

        aboutLayout = QVBoxLayout(awidget)

        aboutIcon = QLabel()
        aboutIcon.setPixmap( QIcon.fromTheme('locatefromcell').pixmap(48,48) )
        aboutIcon.setAlignment( Qt.AlignCenter or Qt.AlignHCenter )
        aboutIcon.resize(128,128)
        aboutLayout.addWidget(aboutIcon)

        aboutLabel = QLabel('''<center><b>Locate From Cell</b> %s
                                   <br>
                                   <br>
                                   <b>The Locate From Cell application
                                   <br>uses the cell tower information  
                                   <br>to locate your location   
                                   <br>coordinates.</b>
                                   <br>
                                   <br>Licenced under GPLv2
                                   <br>by <b>Christos Zamantzas</b> (Saturn)
                                   <br>
                                   <br>The application makes use of the  
                                   <br>CellID parameters and Google APIs   
                                   <br>to locate your position in a map.  
                                   <br>
                                   <br>
                                   <b>Additional information on the usage, 
                                   <br>settings and implications can be found 
                                   <br>in the wiki page</b>
                                   <br>
                                   <br>
                                   <br><b>Thanks to :</b>
                                   <br><b>Benoit HERVIER</b> at http://khertan.net/
                                   <br>for the code used in this about window
                                   <br>and the pyPackager utility.
                                   <br>
                                   </center>''' % Version)
        aboutLayout.addWidget(aboutLabel)
        self.bugtracker_button = QPushButton('BugTracker')
        self.bugtracker_button.clicked.connect(self.open_bugtracker)
        self.website_button = QPushButton('Wiki Page')
        self.website_button.clicked.connect(self.open_website)
        awidget2 = QWidget()
        buttonLayout = QHBoxLayout(awidget2)        
        buttonLayout.addWidget(self.bugtracker_button)
        buttonLayout.addWidget(self.website_button)
        aboutLayout.addWidget(awidget2)
        
        awidget.setLayout(aboutLayout)
        aboutScrollArea.setWidget(awidget)
        self.setCentralWidget(aboutScrollArea)
        self.show()        
        
    def open_website(self):
        QDesktopServices.openUrl(QUrl('http://wiki.maemo.org/Locate_From_Cell'))
    def open_bugtracker(self):
        QDesktopServices.openUrl(QUrl('https://bugs.maemo.org'))
 
class LocateFromCellMainWindow(QtGui.QMainWindow): #FIXME: cleanup of old code, fill lineEdits, disable LineEdits.

     def __init__(self, parent=None):
         
         ##Build parent user interface
         QtGui.QWidget.__init__(self, parent)
         self.ui = Ui_locateFromCellUI()
         self.ui.setupUi(self)
         self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
         self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
         
         ##Connect the GUI Buttons with actions
           ##Create Settings
         QtCore.QObject.connect(self.ui.btnGetCellID, QtCore.SIGNAL('clicked()'), self.doGetCellID)
         QtCore.QObject.connect(self.ui.btnGetLocation, QtCore.SIGNAL('clicked()'), self.doGetLocation)
         QtCore.QObject.connect(self.ui.btnSeeMap, QtCore.SIGNAL('clicked()'), self.doSeeMap)
         QtCore.QObject.connect(self.ui.btnGoogleMaps, QtCore.SIGNAL('clicked()'), self.doOpenGoogleMaps)
         
           ##Connect Menu Buttons 
         QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), QtGui.qApp, QtCore.SLOT('quit()'))
         QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.doAbout)

          ## Disable all menu entries 
         self.ui.lineCellID.setEnabled(False)
         self.ui.lineMCC.setEnabled(False)
         self.ui.lineMNC.setEnabled(False)
         self.ui.lineLAC.setEnabled(False)
         self.ui.lineLON.setEnabled(False)
         self.ui.lineLAT.setEnabled(False)
          ## Disable buttons that cannot be used just yet
         self.ui.btnSeeMap.setEnabled(False)
         self.ui.btnGoogleMaps.setEnabled(False)

     ##Create Methods
     def doAbout(self):
    
         stackwindow = LocateFromCellAbout(self)
         stackwindow.show()

     def doGetCellID(self):
         ''' Get cellid info from system'''

         MCC,MNC,LAC,CELLID = self.get_cellid_info()
         print MCC, MNC, LAC, CELLID

         self.ui.lineCellID.setText(str(CELLID))
         self.ui.lineMCC.setText(str(MCC))
         self.ui.lineMNC.setText(str(MNC))
         self.ui.lineLAC.setText(str(LAC))
         
     def doGetLocation(self):
         ''' Get coordinates from Google mmap API'''

         MCC,MNC,LAC,CELLID = self.get_cellid_info()
         print MCC, MNC, LAC, CELLID

         LAT,LON=self.get_location_by_cell(CELLID, LAC, MNC, MCC)
         print LAT, LON

         self.ui.lineCellID.setText(str(CELLID))
         self.ui.lineMCC.setText(str(MCC))
         self.ui.lineMNC.setText(str(MNC))
         self.ui.lineLAC.setText(str(LAC))
         self.ui.lineLON.setText(str(LON))
         self.ui.lineLAT.setText(str(LAT))
         
         self.ui.btnSeeMap.setEnabled(True)
         self.ui.btnGoogleMaps.setEnabled(True)

     def doSeeMap(self):
         ''' Store a png from location''' 
         LAT = float(self.ui.lineLAT.text())
         LON = float(self.ui.lineLON.text())

         self.storeMap(LAT, LON)

         stackwindow = OpenImage(self)
         stackwindow.show()

     def doOpenGoogleMaps(self):
         ''' Open browser @ google maps @ coordinates'''
         LAT = float(self.ui.lineLAT.text())
         LON = float(self.ui.lineLON.text())
         os.system('%s"%s?q=%f,%f"' % (dbus_browser, url_map, LAT, LON))
     
     def someother(self):

         self.get_location_by_geo(LAT, LON)

     def fetch_latlong_http(self, query):
         http = HTTP('www.google.com', 80)
         http.putrequest('POST', '/glm/mmap')
         http.putheader('Content-Type', 'application/binary')
         http.putheader('Content-Length', str(len(query)))
         http.endheaders()
         http.send(query)
         code, msg, headers = http.getreply()
         result = http.file.read()
         return result

     def fetch_latlong_urllib(self, query):
         headers = { 'User-Agent' : user_agent }
         req = urllib2.Request(url_mmap, query, headers)
         resp = urllib2.urlopen(req)
         response = resp.read()
         return response

     fetch_latlong = fetch_latlong_http

     def get_location_by_cell(self, cid, lac, mnc=0, mcc=0, country="en"):
         print country
         b_string = pack('>hqh2sh13sh5sh3sBiiihiiiiii',
                        21, 0,
                        len(country), country,
                        len(device), device,
                        len('1.3.1'), "1.3.1",
                        len('Web'), "Web",
                        27, 0, 0,
                        3, 0, cid, lac,
                        0, 0, 0, 0)

         bytes = self.fetch_latlong_http(b_string)
         (a, b,errorCode, latitude, longitude, c, d, e) = unpack(">hBiiiiih",bytes)
         latitude = latitude / 1000000.0
         longitude = longitude / 1000000.0

         return latitude, longitude

     def get_location_by_geo(self, latitude, longitude):
         url = '%s?q=%s,%s&output=json&oe=utf8' % (url_geo, str(latitude), str(longitude))
         return urllib2.urlopen(url).read()

     def storeMap(self, latitude, longitude):
         '''Create map of current coordinates.'''

         MapZoom     = 16
         MapSize     = (800,390)
         MarkerColor = 'red'
         MarkerLabel = 'N'

         MapUrl = 'http://maps.google.com/maps/api/staticmap?center=%s,%s&zoom=%s&size=%sx%s&format=png&markers=color:%s|label:%s|%s,%s&sensor=true' \
                  % (latitude,
                     longitude,
                     MapZoom,
                     MapSize[0],
                     MapSize[1],
                     MarkerColor,
                     MarkerLabel,
                     latitude,
                     longitude)
         try:
             print MapUrl
             urllib.urlretrieve( MapUrl, '%s/%s' % (LogPath, MapName) )
         except:
             print 'WARNING: failed to create coordinate map (retrieve error)'
             return False
         else:
             if os.path.isfile( '%s/%s' % (LogPath, MapName) ) == True:
                 print 'INFO: created coordinate map'
                 return True
             else:
                 print 'WARNING: failed to create coordinate map (file not found)'
                 return False
 
     def get_cellid_info(self):
         '''Get cellid info from system'''
         
         info = os.popen(dbus_cellid).read().replace('   byte ','').replace('   uint32 ','').replace('   uint16 ','').replace('   int32 ','').split('\n')
         MCC    = int(info[4])
         MNC    = int(info[3])
         LAC    = int(info[1])
         CELLID = int(info[2])

         return MCC, MNC, LAC, CELLID

class OpenImage(QtGui.QMainWindow):
    def __init__(self, parent = None):
         imgFile = '/home/user/.locatefromcell/map.png'
         QMainWindow.__init__(self,parent)
         self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
         self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
         self.setWindowTitle("Map image of location")
         self.image = QtGui.QImage(imgFile)#.scaled(800,450,Qt.KeepAspectRatio)
         #self.resize(self.image.size())

    def paintEvent(self, event):
         p = QtGui.QPainter(self)
         p.drawImage(event.rect(), self.image)

         self.show()
         
class LocateFromCellMain(): 

     ##Check with what priviledges the GUI has been executed
     if os.geteuid() == 0:
         message = 'ERROR: The application cannot be executed as root. Exiting..'
         showMessage(message)
         sys.exit(1)
     else:
         pass

     ##Check if temp folder is available
     if os.path.exists(LogPath) == False:
         os.system('mkdir %s' % LogPath)
     else:
         pass

     ##Open Dialog Window
     app = QtGui.QApplication(sys.argv)
     myapp = LocateFromCellMainWindow()
     myapp.show()
     sys.exit(app.exec_())     