/*vim: set sw=4 ts=4 et: */
/*
 * This file is part of Live Wallpaper (livewp)
 * 
 * Copyright (C) 2010 Vlad Vasiliev
 * Copyright (C) 2010 Tanya Makova
 *       for the code
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
*/
/*******************************************************************************/
#include "livewp-common.h" 
#include "livewp-home-widget.h"
#include <gconf/gconf-client.h>
#include "livewp-rules.h"
#include "livewp-scene.h"
#include <sys/time.h>
#include <stdlib.h>

#define GCONF_KEY_POSITION "/apps/osso/hildon-desktop/applets/livewp-home-widget.desktop-%i/position"
#define GCONF_KEY_MODIFIED "/apps/osso/hildon-desktop/applets/livewp-home-widget.desktop-%i/modified"
#define GCONF_KEY_VIEW     "/apps/osso/hildon-desktop/applets/livewp-home-widget.desktop-%i/view"

HD_DEFINE_PLUGIN_MODULE (AWallpaperPlugin, animation_wallpaper_plugin, HD_TYPE_HOME_PLUGIN_ITEM)
#define Animation_Wallpaper_HOME_PLUGIN_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj,\
                                                          Animation_Wallpaper_TYPE_HOME_PLUGIN,\
                                                          Animation_WallpaperPrivate))
static void
lw_applet_realize (GtkWidget *widget)
{
    GdkScreen *screen;
    gchar * strid; 
    gint id; 
    AWallpaperPlugin *desktop_plugin = widget;

    strid = g_strdup(hd_plugin_item_get_plugin_id (HD_PLUGIN_ITEM (widget)));
    id = strid[strlen(strid)-1] - '0';
    desktop_plugin->priv->view = id;
    g_free(strid); 
    
    /* Load config */
    read_config(desktop_plugin->priv);

    init_scene_theme(desktop_plugin);
        
    desktop_plugin->priv->long_timer = g_timeout_add(LONG_TIMER, (GtkFunction)long_timeout, desktop_plugin);

    screen = gtk_widget_get_screen (widget);
    gtk_widget_set_colormap (widget,
                                gdk_screen_get_rgba_colormap (screen));
    gtk_widget_set_app_paintable (widget,
                                TRUE);
    GTK_WIDGET_CLASS (animation_wallpaper_plugin_parent_class)->realize (widget);
}


static gboolean
lw_applet_expose_event(GtkWidget      *widget,
                                        GdkEventExpose *event)
{
  cairo_t *cr;

  /* Create cairo context */
  cr = gdk_cairo_create (GDK_DRAWABLE (widget->window));
  gdk_cairo_region (cr, event->region);
  cairo_clip (cr);

  /* Draw alpha background */
  cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
  cairo_set_source_rgba (cr, 0.0, 0.0, 0.0, 0.0);
  cairo_paint (cr);

  /* Free context */
  cairo_destroy (cr);

  return GTK_WIDGET_CLASS (animation_wallpaper_plugin_parent_class)->expose_event (widget,
                                                                                  event);
}

static gboolean
expose_event (GtkWidget *widget,GdkEventExpose *event,
     gpointer data)
{
    cairo_t *cr;
    GdkPixbuf *pixbuf = (GdkPixbuf *) data;
	
    cr = gdk_cairo_create(widget->window);
    if (cr){
        gdk_cairo_region(cr, event->region);
        cairo_set_operator(cr, CAIRO_OPERATOR_SOURCE);
        gdk_cairo_set_source_pixbuf(cr, pixbuf, 0.0, 0.0);
        cairo_paint(cr);
        cairo_destroy(cr);
    }
    return TRUE;
}

static void
realize (GtkWidget *widget)
{
    GdkScreen *screen;
    screen = gtk_widget_get_screen (widget);
    gtk_widget_set_colormap (widget, gdk_screen_get_rgba_colormap (screen));
}
/* Set position of widget on desktop */
static void
init_applet_position(gint *xapplet, gint *yapplet)
{
  GSList *position = NULL;
  gchar *position_key;
  gchar *modified_key;
  gchar *modified;
  GError *error = NULL;
  gint i;
  GConfClient   *gconf_client = gconf_client_get_default ();
  for (i=0;i<4;i++){
      position_key = g_strdup_printf (GCONF_KEY_POSITION, i);
      position = gconf_client_get_list (gconf_client,
                                        position_key,
                                        GCONF_VALUE_INT,
                                        NULL);
      if (position && position->data && position->next->data){
        *xapplet = GPOINTER_TO_INT (position->data);
        *yapplet = GPOINTER_TO_INT (position->next->data);
      }else{
        position = g_slist_prepend (g_slist_prepend (NULL,
                                          GINT_TO_POINTER (Ystartposition)),
                              GINT_TO_POINTER (Xstartposition));
        gconf_client_set_list (gconf_client,
                                   position_key,
                                   GCONF_VALUE_INT,
                               position,
                       &error);
        *xapplet = Xstartposition;
        *yapplet = Ystartposition;
      }
      g_free (position_key);
      modified = g_strdup_printf ("%i", 0);
      modified_key = g_strdup_printf (GCONF_KEY_MODIFIED, i);
      gconf_client_set_string (gconf_client,
                               modified_key,
                               modified,
                               &error);
      g_free(modified);
      g_free(modified_key);
      modified_key = g_strdup_printf (GCONF_KEY_VIEW, i);
      gconf_client_set_int (gconf_client,
                               modified_key,
                               (i+1),
                               &error);
      g_free(modified_key);

  }
  gconf_client_clear_cache(gconf_client);
  g_object_unref(gconf_client);
}
#if 0
void
actor_set_position_full(GtkWidget *actor, gint x, gint y, gint z)
{
/*  fprintf(stderr, "actor_set_position_full z=%d\n", z); */
    hildon_animation_actor_set_position_full (HILDON_ANIMATION_ACTOR (actor),x-0, y-0, z);
}
#endif

void
destroy_hildon_actor(Actor *actor)
{
    //fprintf(stderr, "destroy_hildon_actor %s\n",actor->name);
    gtk_widget_destroy(actor->widget);
    actor->widget = NULL;
}

void
create_hildon_actor_text(Actor *actor, AWallpaperPlugin *desktop_plugin) 
{
  GtkWidget *ha = NULL;
  GdkPixbuf *pixbuf = NULL;
  GtkWidget *image = NULL;
  GtkWidget *label = NULL;

  ha = hildon_animation_actor_new();
  label = gtk_label_new(NULL);  

  if (label){
    //g_signal_connect(G_OBJECT(label), "expose_event", G_CALLBACK(expose_event), NULL);

    gtk_container_add (GTK_CONTAINER (ha), label);
  }  
  realize(ha);
  gtk_widget_show(label);
  gtk_widget_show_all(ha);
  
  /* TO DO check it */
  /*  gdk_flush (); */

  //g_object_set_data(G_OBJECT(ha), "image", image);
  actor->image = label;
  hildon_animation_actor_set_parent (HILDON_ANIMATION_ACTOR (ha), GTK_WINDOW(desktop_plugin));
  actor->widget = ha;
  set_actor_position(actor, actor->x, actor->y, actor->z, desktop_plugin);
  set_actor_scale(actor, (double)actor->scale/100, (double)actor->scale/100);
  set_actor_visible(actor, actor->visible);
}



void
create_hildon_actor(Actor *actor, AWallpaperPlugin *desktop_plugin) 
{
  GtkWidget *ha = NULL;
  GdkPixbuf *pixbuf = NULL;
  GtkWidget *image = NULL;
  gchar     *str = NULL;

  ha = hildon_animation_actor_new();
  str = g_strdup_printf( "%s/%s/%s", THEME_PATH, 
                        desktop_plugin->priv->theme, actor->filename);
  pixbuf = gdk_pixbuf_new_from_file_at_size (str, 
                                             actor->width, 
                                             actor->height, 
                                             NULL);
  /*fprintf(stderr, "create_hildon_actor %s %s\n", actor->name, str);*/
  if (str)
      g_free(str);
  if (pixbuf){
      image = gtk_image_new_from_pixbuf (pixbuf);
      g_object_unref(G_OBJECT(pixbuf));
  }
  if (image){
    g_signal_connect(G_OBJECT(image), "expose_event",
                           G_CALLBACK(expose_event), pixbuf);
    gtk_container_add (GTK_CONTAINER (ha), image);
  }  
  realize(ha);
  gtk_widget_show_all(ha);
  
  /* TO DO check it */
  /*  gdk_flush (); */

  //g_object_set_data(G_OBJECT(ha), "image", image);
  actor->image = image;
  hildon_animation_actor_set_parent (HILDON_ANIMATION_ACTOR (ha), GTK_WINDOW(desktop_plugin));

  actor->widget = ha;
  set_actor_position(actor, actor->x, actor->y, actor->z, desktop_plugin);
  set_actor_scale(actor, (double)actor->scale/100, (double)actor->scale/100);
  set_actor_visible(actor, actor->visible);
}


void
change_hildon_actor(Actor *actor, AWallpaperPlugin *desktop_plugin)
{
    GtkWidget *image = NULL;
    GdkPixbuf *pixbuf = NULL;
    gchar     *str = NULL;

    str = g_strdup_printf( "%s/%s/%s", THEME_PATH, 
                            desktop_plugin->priv->theme, actor->filename);
 
    pixbuf = gdk_pixbuf_new_from_file_at_size (str, 
                                               actor->width, 
                                               actor->height, 
                                               NULL);
    if(str)
        g_free(str);
    if (pixbuf){
        image = gtk_image_new_from_pixbuf (pixbuf);
        g_object_unref(G_OBJECT(pixbuf));
    }
    if (image){ 
        g_signal_connect(G_OBJECT(image), "expose_event",
                                       G_CALLBACK(expose_event), pixbuf);
        //if (g_object_get_data(G_OBJECT(actor->widget), "image")){
        if (actor->image){
            gtk_container_remove(GTK_CONTAINER(actor->widget), actor->image);  
        }
        //g_object_set_data(G_OBJECT(actor->widget), "image", image);
        actor->image = image;
        gtk_container_add (GTK_CONTAINER (actor->widget), image);
        realize(actor->widget);
        gtk_widget_show_all(actor->widget);
        /* TO DO check it */
       /*  gdk_flush (); */


    }

}


static gboolean
short_timeout (AWallpaperPlugin *desktop_plugin)
{
    //gint daytime = get_daytime();
    GSList * tmp;
    void (*pfunc)(gpointer, gpointer);
    time_t now;
    Actor *actor;
    gboolean stop_flag = TRUE;

if (!desktop_plugin->priv->visible || !desktop_plugin->priv->rich_animation){
        desktop_plugin->priv->short_timer = 0;
        return FALSE;
    }

    now = time(NULL);
    //scene.daytime = daytime;
    /* fprintf(stderr, "Short timer %d\n", now); */
    tmp = desktop_plugin->priv->scene->actors;
    while (tmp != NULL){
           actor = tmp->data;
           if (now >= actor->time_start_animation  
               && actor->time_start_animation > 0
               /* && now - actor->time_start_animation <= actor->duration_animation*/){
                pfunc = actor->func_change;
                if (pfunc){ 
                    (*pfunc)(actor, desktop_plugin);
                    stop_flag = FALSE;
                }
            }
            tmp = g_slist_next(tmp);
    }
    if (stop_flag){
         desktop_plugin->priv->short_timer = 0;
         return FALSE;
    }else
         return TRUE; /* keep running this event */
}

void
run_long_timeout(AWallpaperPlugin *desktop_plugin)
{

    gint daytime = get_daytime();
    GSList * tmp;
    void (*pfunc)(gpointer, gpointer);
    time_t now;
    Actor *actor;

    if (!desktop_plugin->priv->scene)
	return;
    //fprintf(stderr, "!!!run long timeout short_timer=%d\n", desktop_plugin->priv->short_timer);
    if (desktop_plugin->priv->scene->daytime != daytime){
        desktop_plugin->priv->scene->daytime = daytime;
        tmp = desktop_plugin->priv->scene->actors;
        while (tmp != NULL){
            //change_actor(tmp->data);
            pfunc =((Actor*)tmp->data)->func_change;
            if (pfunc){
                (*pfunc)(tmp->data, desktop_plugin);
            }
            tmp = g_slist_next(tmp);
        }
    }
   
    now = time(NULL);
    //fprintf(stderr, "Now  %d\n", now);
    tmp = desktop_plugin->priv->scene->actors;
    while (tmp != NULL){
        actor = tmp->data;
        if (now >= actor->time_start_animation  
            && actor->time_start_animation > 0
            && desktop_plugin->priv->short_timer == 0){
            /* fprintf(stderr, "start short timer act = %s %d\n", actor->name, now); */
            if (desktop_plugin->priv->rich_animation){
                actor->time_start_animation = now;
                desktop_plugin->priv->short_timer = g_timeout_add(SHORT_TIMER, (GtkFunction)short_timeout, desktop_plugin);
            }
            else {
                (*actor->func_change)(actor, desktop_plugin);
            }
        }
        tmp = g_slist_next(tmp);
    }
 
}

static gboolean
long_timeout (AWallpaperPlugin *desktop_plugin)
{
    /* fprintf(stderr, "long_timeout %i\n", desktop_plugin->priv->long_timer); */
    if (desktop_plugin->priv->long_timer == 0 )
        return FALSE;
    if (!desktop_plugin->priv->visible){
        if(desktop_plugin->priv->short_timer != 0){
            g_source_remove(desktop_plugin->priv->short_timer);
            desktop_plugin->priv->short_timer = 0;
        }
        desktop_plugin->priv->long_timer = 0;
        return FALSE;
    }
  

    run_long_timeout(desktop_plugin);
    return TRUE; /* keep running this event */
}

static void
desktop_plugin_visible_notify (GObject    *object,
                                          GParamSpec *spec,
                                          AWallpaperPlugin *desktop_plugin)
{
    gboolean visible;
    g_object_get (object, "is-on-current-desktop", &visible, NULL);
    /* fprintf (stderr, "is-on-current-desktop changed. visible: %u", visible); */
    if (visible){
        desktop_plugin->priv->visible = TRUE;
        if (desktop_plugin->priv->long_timer == 0 ){
            desktop_plugin->priv->long_timer = g_timeout_add(LONG_TIMER, (GtkFunction)long_timeout, desktop_plugin);
            run_long_timeout(desktop_plugin);
        }
    }else{
        desktop_plugin->priv->visible = FALSE;
        if (desktop_plugin->priv->long_timer != 0 ){
            g_source_remove(desktop_plugin->priv->long_timer);
            desktop_plugin->priv->long_timer = 0;
        }
    }
}
gboolean
rich_animation_press(GtkWidget *widget, GdkEvent *event,
                                            gpointer user_data){
    fprintf(stderr,"gggggggggggggggggggg2222\n");
    return FALSE;
}    
static void
animation_wallpaper_plugin_init (AWallpaperPlugin *desktop_plugin)
{
    GtkWidget *rich_animation;
    gchar           buffer[2048];
    gchar str[128];

    //fprintf(stderr, "!!!!!!!plugin init \n");
    Animation_WallpaperPrivate *priv =  Animation_Wallpaper_HOME_PLUGIN_GET_PRIVATE (desktop_plugin);
    desktop_plugin->priv =  Animation_Wallpaper_HOME_PLUGIN_GET_PRIVATE (desktop_plugin);
    priv->osso = osso_initialize(PACKAGE, VERSION, TRUE, NULL);

        /* Initialize DBUS */
    livewp_initialize_dbus(priv);

    priv->desktop_plugin = desktop_plugin;
    priv->visible = TRUE;
    priv->short_timer = 0;
    priv->xapplet = 0;
    priv->yapplet = 0;
    priv->scene = NULL;
//    priv->theme = g_strdup("Modern");
//#if 0 
    priv->hash_scene_func = g_hash_table_new(g_str_hash, g_str_equal);
    
    g_hash_table_insert(priv->hash_scene_func, g_strdup("Berlin"), (gpointer)&init_scene_Berlin);
    g_hash_table_insert(priv->hash_scene_func, g_strdup("Modern"), (gpointer)&init_scene_Modern);
    g_hash_table_insert(priv->hash_scene_func, g_strdup("Matrix"), (gpointer)&init_scene_Matrix);
//#endif
    //priv->theme = g_strdup("Modern");
    desktop_plugin->priv->main_widget = gtk_fixed_new();

    gtk_widget_set_size_request(desktop_plugin->priv->main_widget, 100, 32);
    desktop_plugin->priv->right_corner = NULL;
    snprintf(buffer, sizeof(buffer) - 1, "%s/%s/%s", THEME_PATH, desktop_plugin->priv->theme, "town0_right_corner.png");
    desktop_plugin->priv->right_corner = gtk_image_new_from_file (buffer);
    if (desktop_plugin->priv->right_corner){
        gtk_fixed_put(GTK_FIXED(desktop_plugin->priv->main_widget), desktop_plugin->priv->right_corner, 0, 0);
        gtk_widget_show (desktop_plugin->priv->right_corner);
    }
    /* Create rich animation event */
    rich_animation = gtk_event_box_new();
    if(rich_animation){
        gtk_widget_set_events(rich_animation, GDK_BUTTON_PRESS_MASK);
        gtk_event_box_set_visible_window(GTK_EVENT_BOX(rich_animation), FALSE);
        gtk_widget_set_size_request(rich_animation, 100, 32);
        gtk_widget_show (rich_animation);
        g_signal_connect(rich_animation, "button-press-event", G_CALLBACK(rich_animation_press), desktop_plugin);
        gtk_fixed_put(GTK_FIXED(desktop_plugin->priv->main_widget), rich_animation, 0, 0);
    }
#if 0
    GtkWidget *label = gtk_label_new ("1111ddddddddd");
    gtk_widget_set_size_request(label, 95, 30);
    gtk_widget_show (label);
    gtk_container_add (GTK_CONTAINER (desktop_plugin), label);
#endif
    hd_home_plugin_item_set_settings (HD_HOME_PLUGIN_ITEM (desktop_plugin), TRUE);
    g_signal_connect (desktop_plugin, "show-settings",
		             G_CALLBACK (show_settings), priv);
    gtk_widget_show (desktop_plugin->priv->main_widget);
    gtk_container_add (GTK_CONTAINER (desktop_plugin), desktop_plugin->priv->main_widget);
    init_applet_position(&(priv->xapplet), &(priv->yapplet));

    
    //fprintf(stderr, "!!!theme = %s\n", priv->theme);
    //snprintf(str, sizeof(str) - 1, "%s", "init_scene2");
    //fprintf(stderr, " str = %s\n", str);
    priv->scene = NULL;
#if 0
    if (!strcmp(priv->theme,"Modern"))
        init_scene_Modern(desktop_plugin);
    else if (!strcmp(priv->theme,"Berlin")) 
        init_scene_Berlin(desktop_plugin);
    else if (!strcmp(priv->theme, "Matrix"))
        init_scene_Matrix(desktop_plugin);
#endif
//    init_scene_theme(desktop_plugin);
        
//    priv->long_timer = g_timeout_add(LONG_TIMER, (GtkFunction)long_timeout, desktop_plugin);
    /* TODO Move scene to priv */
    //scene.timer_type = LONG_TIMER_TYPE;
    g_signal_connect (desktop_plugin, "notify::is-on-current-desktop",
                   G_CALLBACK (desktop_plugin_visible_notify), desktop_plugin);

   
    //sleep(2);
}

static void
lw_applet_finalize (GObject *object)
{
fprintf(stderr,"lw_applet_finalize\n");
/*
     AWallpaperPlugin *desktop_plugin = Animation_Wallpaper_HOME_PLUGIN (object);
     Animation_WallpaperPrivate *priv = desktop_plugin->priv;
     
     if (priv){
	     livewp_deinitialize_dbus(priv);
	     fprintf(stderr,"finalaze %i\n", priv->long_timer);
	     if (priv->long_timer){
		g_source_remove(priv->long_timer);
		priv->long_timer = 0;
	     }
	     if (priv->short_timer){
		g_source_remove(priv->short_timer);
		priv->short_timer = 0;
	     }

	     destroy_scene(desktop_plugin);
     }
*/
}

static void
desktop_widget_finalize (GObject *object)
{
     AWallpaperPlugin *desktop_plugin = Animation_Wallpaper_HOME_PLUGIN (object);
     Animation_WallpaperPrivate *priv = desktop_plugin->priv;
     
     if (priv){
	     livewp_deinitialize_dbus(priv);
	     fprintf(stderr,"finalaze %i\n", priv->long_timer);
	     if (priv->long_timer){
		g_source_remove(priv->long_timer);
		priv->long_timer = 0;
	     }
	     if (priv->short_timer){
		g_source_remove(priv->short_timer);
		priv->short_timer = 0;
	     }

	     destroy_scene(desktop_plugin);
     }
      /* Call the base class's implementation: */
      G_OBJECT_CLASS (animation_wallpaper_plugin_parent_class)->finalize (object);
}

static void
animation_wallpaper_plugin_class_init (AWallpaperPluginClass *klass) {

    GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (klass);
    GtkObjectClass *gobject_class = GTK_OBJECT_CLASS (klass);
    GObjectClass *object_class = G_OBJECT_CLASS (klass);

    /* gobject */
    gobject_class->destroy = (gpointer)lw_applet_finalize;
    object_class->finalize = desktop_widget_finalize;
    widget_class->realize = lw_applet_realize;
    widget_class->expose_event = lw_applet_expose_event;

    g_type_class_add_private (klass, sizeof (Animation_WallpaperPrivate));

}

static void
animation_wallpaper_plugin_class_finalize (AWallpaperPluginClass *class) {
}

Animation_WallpaperPrivate*
animation_wallpaper_plugin_new (void)
{
  return g_object_new (Animation_Wallpaper_TYPE_HOME_PLUGIN , NULL);
}

