/* vim: set sw=4 ts=4 et: */
/*
 * This file is part of Live Wallpaper (livewp)
 * 
 * Copyright (C) 2010 Vlad Vasiliev
 * Copyright (C) 2010 Tanya Makova
 *       for the code
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
*/
/*******************************************************************************/
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <locale.h>
#include <libhildondesktop/libhildondesktop.h>

#define GETTEXT_PACKAGE "livewp"
#include <glib/gi18n-lib.h>

#define THEME_PATH "/usr/share/livewp/theme"
#define SHORT_TIMER 50 /* 100 milisecond */
//#define LONG_TIMER 5*60*1000 /* 10 minutes */
#define LONG_TIMER  10*1000 /* 10 minutes */
enum { SHORT_TIMER_TYPE, LONG_TIMER_TYPE };
#define SKY_LEVEL 0 
#define SUN_LEVEL 0 
#define TOWN_LEVEL 0 
#define TRAM_LEVEL 20 


typedef struct _AWallpaperPlugin AWallpaperPlugin;
typedef struct _AWallpaperPluginClass AWallpaperPluginClass;
typedef struct _Animation_WallpaperPrivate Animation_WallpaperPrivate;

struct _Animation_WallpaperPrivate
{
    gint long_timer;
    gint short_timer;
    gchar *theme;
    gboolean visible;
    gboolean rich_animation;
    GtkWidget *main_widget;
    GtkWidget *right_corner;
    AWallpaperPlugin *desktop_plugin;
};

struct _AWallpaperPlugin
{
    HDHomePluginItem parent;
    Animation_WallpaperPrivate *priv;
};

struct _AWallpaperPluginClass
{
    HDHomePluginItemClass parent_class;

};

typedef struct {
    GtkWidget * widget;
    gchar  *name;
    gchar *filename;
    gint x;
    gint y;
    gint z;
    gint width;
    gint height;
    gint scale;
    gint opacity; 
    gboolean visible;
    void (*func_change)(gpointer, gpointer);
    time_t time_start_animation;
    gint duration_animation;
    void (*func_probability)(gpointer);

} Actor;
