#include <string.h>
#include "configLoader.h"
#ifdef MAEMO
SDLKey KEY_CHBEHAVIOR = SDLK_LCTRL;
SDLKey KEY_CHBEHAVIOR_LEFT = SDLK_LEFT;
SDLKey KEY_CHBEHAVIOR_RIGHT = SDLK_RIGHT;

SDLKey KEY_MENU = SDLK_SPACE;
SDLKey KEY_MENU_UP = SDLK_UP;
SDLKey KEY_MENU_DOWN = SDLK_DOWN;
SDLKey KEY_MENU_ENTER = SDLK_z;
SDLKey KEY_MENU_QUIT = SDLK_q;
SDLKey KEY_CHAR_ACTION = SDLK_z;
SDLKey KEY_CHAR_ACTION_2 = SDLK_x;
SDLKey KEY_CHAR_FORWARD = SDLK_UP;
SDLKey KEY_CHAR_BACKWARD = SDLK_DOWN;
SDLKey KEY_CHAR_LEFT = SDLK_LEFT;
SDLKey KEY_CHAR_RIGHT = SDLK_RIGHT;
SDLKey KEY_CHAR_USEWEAPON = SDLK_a;
SDLKey KEY_CHAR_ATTACK_RPUNCH = SDLK_RIGHT;
SDLKey KEY_CHAR_ATTACK_LPUNCH = SDLK_LEFT;
SDLKey KEY_CHAR_ATTACK_KICK = SDLK_UP;

SDLKey KEY_INVENT_UP = SDLK_UP;
SDLKey KEY_INVENT_DOWN = SDLK_DOWN;
SDLKey KEY_INVENT_LEFT = SDLK_LEFT;
SDLKey KEY_INVENT_RIGHT = SDLK_RIGHT;
SDLKey KEY_INVENT_QUIT = SDLK_q;
SDLKey KEY_INVENT_SHOW = SDLK_SPACE;
SDLKey KEY_INVENT_SELECT = SDLK_z;
SDLKey KEY_ACTION_PROTOPACK = SDLK_j;
SDLKey KEY_ACTION_HOLOMAP = SDLK_h;
SDLKey KEY_PAUSE = SDLK_p;
SDLKey KEY_INVENTORY = SDLK_i;
SDLKey KEY_RECENTER = SDLK_KP_ENTER;
SDLKey KEY_CONTTEXT = SDLK_z;
SDLKey KEY_SKIP = SDLK_ESCAPE;
SDLKey KEY_FULLSCREEN = SDLK_F10;

SDLKey KEY_BEHAVIOR_0 = SDLK_F1;
SDLKey KEY_BEHAVIOR_1 = SDLK_F2;
SDLKey KEY_BEHAVIOR_2 = SDLK_F3;
SDLKey KEY_BEHAVIOR_3 = SDLK_F4;

SDLKey KEY_OPTIONSMENU = SDLK_F6;
#endif
char* CONFIG_FILE_PATH="/home/user/MyDocs/.lba/lba.ini";
void checkConfigFile(){
    FILE *fp;
    fp=fopen(CONFIG_FILE_PATH, "r");
    if(fp==NULL){
        fp=fopen(CONFIG_FILE_PATH, "w");
        if(fp!=NULL){
            fprintf(fp, "[KeyMapping]\n");
            fprintf(fp, "move_forward=up\n");
            fprintf(fp, "move_backward=down\n");
            fprintf(fp, "move_right=right\n");
            fprintf(fp, "move_left=left\n");
            fprintf(fp, "behavior=ctrl\n");
            fprintf(fp, "menu=space\n");
            fprintf(fp, "action=z\n");
            fprintf(fp, "action2=x\n");
            fprintf(fp, "exit=q\n");
            fprintf(fp, "use_weapon=a\n");
            fprintf(fp, "inventory=i\n");
            fprintf(fp, "pause=p\n");
            fprintf(fp, "holomap=h\n");
            fprintf(fp, "protopack=j\n");
            fclose(fp);
        }
    }else{
        fclose(fp);
    }
}

void loadConfig(){
    checkConfigFile();
    char       * ini_name=CONFIG_FILE_PATH;
    dictionary * ini = iniparser_load(ini_name);
    if(ini!=NULL){
        //iniparser_dump(ini, stdout);
        assignKeys(ini);
        iniparser_freedict(ini);
    }
}

SDLKey getKey(char* code){
    SDLKey res=SDLK_FIRST;
    if(strcmp("enter",code)==0){
        res=SDLK_KP_ENTER;
    }else if(strcmp("space",code)==0){
        res=SDLK_SPACE;
    }else if(strcmp("left",code)==0){
        res=SDLK_LEFT;
    }else if(strcmp("right",code)==0){
        res=SDLK_RIGHT;
    }else if(strcmp("up",code)==0){
        res=SDLK_UP;
    }else if(strcmp("down",code)==0){
        res=SDLK_DOWN;
    }else if(strcmp("ctrl",code)==0){
        res=SDLK_LCTRL;
    }else if(strcmp("backspace",code)==0){
        res=SDLK_BACKSPACE;
    }else if(strcmp("shift",code)==0){
        res=SDLK_LSHIFT;
    }else if(strcmp("a",code)==0){
        res=SDLK_a;
    }else if(strcmp("b",code)==0){
        res=SDLK_b;
    }else if(strcmp("c",code)==0){
        res=SDLK_c;
    }else if(strcmp("d",code)==0){
        res=SDLK_d;
    }else if(strcmp("e",code)==0){
        res=SDLK_e;
    }else if(strcmp("f",code)==0){
        res=SDLK_f;
    }else if(strcmp("g",code)==0){
        res=SDLK_g;
    }else if(strcmp("h",code)==0){
        res=SDLK_h;
    }else if(strcmp("i",code)==0){
        res=SDLK_i;
    }else if(strcmp("j",code)==0){
        res=SDLK_j;
    }else if(strcmp("k",code)==0){
        res=SDLK_k;
    }else if(strcmp("l",code)==0){
        res=SDLK_l;
    }else if(strcmp("m",code)==0){
        res=SDLK_m;
    }else if(strcmp("n",code)==0){
        res=SDLK_n;
    }else if(strcmp("o",code)==0){
        res=SDLK_o;
    }else if(strcmp("p",code)==0){
        res=SDLK_p;
    }else if(strcmp("q",code)==0){
        res=SDLK_q;
    }else if(strcmp("r",code)==0){
        res=SDLK_r;
    }else if(strcmp("s",code)==0){
        res=SDLK_s;
    }else if(strcmp("t",code)==0){
        res=SDLK_t;
    }else if(strcmp("u",code)==0){
        res=SDLK_u;
    }else if(strcmp("v",code)==0){
        res=SDLK_v;
    }else if(strcmp("w",code)==0){
        res=SDLK_w;
    }else if(strcmp("x",code)==0){
        res=SDLK_x;
    }else if(strcmp("y",code)==0){
        res=SDLK_y;
    }else if(strcmp("0",code)==0){
        res=SDLK_0;
    }else if(strcmp("1",code)==0){
        res=SDLK_1;
    }else if(strcmp("2",code)==0){
        res=SDLK_2;
    }else if(strcmp("3",code)==0){
        res=SDLK_3;
    }else if(strcmp("4",code)==0){
        res=SDLK_4;
    }else if(strcmp("5",code)==0){
        res=SDLK_5;
    }else if(strcmp("6",code)==0){
        res=SDLK_6;
    }else if(strcmp("7",code)==0){
        res=SDLK_7;
    }else if(strcmp("8",code)==0){
        res=SDLK_8;
    }else if(strcmp("9",code)==0){
        res=SDLK_9;
    }else if(strcmp("z",code)==0){
        res=SDLK_z;
    }else if(strcmp(".",code)==0){
        res=SDLK_PERIOD;
    }else if(strcmp(",",code)==0){
        res=SDLK_COMMA;
    }
    return res;
}

void assignKeys(dictionary* dict){
    char* key="keymapping:move_forward";
    SDLKey res=getKey(iniparser_getstring(dict,key,"up"));
    if(res!=SDLK_FIRST){
        KEY_MENU_UP=res;
        KEY_CHAR_FORWARD=res;
        KEY_CHAR_ATTACK_KICK=res;
        KEY_INVENT_UP=res;
    }
    key="keymapping:move_backward";
    res=getKey(iniparser_getstring(dict,key,"down"));
    if(res!=SDLK_FIRST){
        KEY_MENU_DOWN=res;
        KEY_CHAR_BACKWARD=res;
        KEY_INVENT_DOWN=res;
    }
    key="keymapping:move_left";
    res=getKey(iniparser_getstring(dict,key,"left"));
    if(res!=SDLK_FIRST){
        KEY_CHBEHAVIOR_LEFT=res;
        KEY_CHAR_LEFT=res;
        KEY_CHAR_ATTACK_LPUNCH=res;
        KEY_INVENT_LEFT=res;
    }
    key="keymapping:move_right";
    res=getKey(iniparser_getstring(dict,key,"right"));
    if(res!=SDLK_FIRST){
        KEY_CHBEHAVIOR_RIGHT=res;
        KEY_CHAR_RIGHT=res;
        KEY_CHAR_ATTACK_RPUNCH=res;
        KEY_INVENT_RIGHT=res;
    }
    key="keymapping:behavior";
    res=getKey(iniparser_getstring(dict,key,"ctrl"));
    if(res!=SDLK_FIRST){
        KEY_CHBEHAVIOR=res;
    }
    key="keymapping:menu";
    res=getKey(iniparser_getstring(dict,key,"space"));
    if(res!=SDLK_FIRST){
        KEY_MENU=res;
        KEY_INVENT_SHOW=res;
    }
    key="keymapping:action";
    res=getKey(iniparser_getstring(dict,key,"z"));
    if(res!=SDLK_FIRST){
        KEY_MENU_ENTER=res;
        KEY_CHAR_ACTION=res;
        KEY_INVENT_SELECT=res;
        KEY_CONTTEXT=res;
    }
    key="keymapping:action2";
    res=getKey(iniparser_getstring(dict,key,"x"));
    if(res!=SDLK_FIRST){
        KEY_CHAR_ACTION_2=res;
        KEY_SKIP=res;
    }
    key="keymapping:exit";
    res=getKey(iniparser_getstring(dict,key,"q"));
    if(res!=SDLK_FIRST){
        KEY_MENU_QUIT=res;
        KEY_INVENT_QUIT=res;
    }
    key="keymapping:use_weapon";
    res=getKey(iniparser_getstring(dict,key,"a"));
    if(res!=SDLK_FIRST){
        KEY_CHAR_USEWEAPON=res;
    }
    key="keymapping:inventory";
    res=getKey(iniparser_getstring(dict,key,"i"));
    if(res!=SDLK_FIRST){
        KEY_INVENTORY=res;
    }
    key="keymapping:pause";
    res=getKey(iniparser_getstring(dict,key,"p"));
    if(res!=SDLK_FIRST){
        KEY_PAUSE=res;
    }
    key="keymapping:holomap";
    res=getKey(iniparser_getstring(dict,key,"h"));
    if(res!=SDLK_FIRST){
        KEY_ACTION_HOLOMAP=res;
    }
    key="keymapping:protopack";
    res=getKey(iniparser_getstring(dict,key,"j"));
    if(res!=SDLK_FIRST){
        KEY_ACTION_PROTOPACK=res;
    }
}
