/*
 * This file is part of the Liquid project.
 * It is header file of class MainWindow, which provides an
 * user interface of project.
 *
 * Copyright (C) 2009 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2009 Volkov A.A. <volkov@cs.karelia.ru>
 * Copyright (C) 2009 Dmitriev V.V. <vdmitrie@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
//! UI Module
/*!
  It provides an interface for user.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H
#define dT 0.01

#include <QMainWindow>
#include <QMenu>
#include <QAction>
#include <QVector3D>
#include "core/painter.h"
#include "accelerometer/accelerometer.h"
#include <QToolButton>
#include <QContextMenuEvent>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    //! A constructor.
    MainWindow(QWidget *parent = 0);
    //! An instance of Painter class.
    Painter *painter;
    //! An instance of ErrorHandler class.
    ErrorHandler *errorHandler;
    //! A destructor.
    ~MainWindow();

    //! This var contains a name of current file.
    QString m_fileName;

protected:
    void changeEvent(QEvent *e);
    void closeEvent(QCloseEvent *);   
    bool event(QEvent *event);

private:
    Ui::MainWindow *ui;
    //! Creates actions for menu.
    void createActions();
    //! Creates menus.
    void createMenus();

    //! An exit dialog.
    /*!
      Shows a dilog for saving if file was modified and not saved.
    */
    bool showExitDialog();    

    //! File menu.
    QMenu *fileMenu;
    //! Mode menu.
    QMenu *modeMenu;
    //! About menu
    QMenu *aboutMenu;    

    //! Action for activating an accelerometer mode.
    QAction *toggleAcc;
    //! Action for creating new image.
    QAction *newAct;
    //! "Open file" action for File menu.
    QAction *openAct;
    //! "Save" action for File menu.
    QAction *saveAct;
    //! "Save file As" action for File menu.
    QAction *saveAsAct;
    //! "Exit" action for File menu.
    QAction *exitAct;
    //! "About" action for About menu.
    QAction *aboutAct;
    //! Action for showing color tool.
    QAction *colorToolAct;
    //! Action for choosing Drop tool as current.
    QAction *eraserAct;    
    //! Action for choosing Brush tool as current.
    QAction *brushAct;
    //! Action for activate/disable full screen.
    QAction *fullScreenAct;
    //! Action for choosing Ice tool as current.
    QAction *iceAct;    

private slots:
    //! Shows a color tool, in which user can choose a color.
    void showColorDialog();
    //! Sets Drop tool as current.
    void setEraser();
    //! Sets Brush tool as current.
    void setBrush();
    //! Triggers if user choose "New" in File Menu.
    void newImage();
    //! Triggers if user choose "Save" in File Menu.
    void save();
    //! Triggers if user choose "Open file" in File menu.
    void open();
    //! Triggers if user choose "Save As" in File menu.
    bool saveAs();
    //! Triggers if user used full screen button.
    void fullScreen(bool);
    //! Triggers if user choose "Accelerometer" in Mode menu.
    void toggleAccelerometer(bool);
    //! Disables accelerometer mode.
    void disableAccelerometer();
    //! Enables accelerometer mode.
    void activateAccelerometer();
    //! Sets Ice tool as current.
    void setIce();
    void showAbout(); /*! Shows about program dialog. */    

signals:
    void sigBgModeChanged(const QString &state);
};

#endif // MAINWINDOW_H
