/*
 * This file is part of the Liquid project.
 * This class handles different states of device (Display On/Off).
 *
 * Copyright (C) 2009 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2009 Volkov A.A. <volkov@cs.karelia.ru>
 * Copyright (C) 2009 Dmitriev V.V. <vdmitrie@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "mce.h"
#include <QDebug>
#include <QList>

#define MCE_DISPLAY_STATUS_GET "get_display_status"
#define MCE_SERVICE "com.nokia.mce"
#define MCE_REQUEST_PATH "/com/nokia/mce/request"
#define MCE_REQUEST_IF "com.nokia.mce.request"
#define MCE_DISPLAY_SIG "display_status_ind"

#define MCE_DISPLAY_ON_STRING "on"
#define MCE_DISPLAY_OFF_STRING "off"
#define MCE_SIGNAL_IF "com.nokia.mce.signal"
#define MCE_SIGNAL_PATH "/com/nokia/mce/signal"

static QDBusConnection dBusConnection = QDBusConnection::systemBus();

MCE::MCE(QObject *parent):
    QObject(parent)
{
    // Create dbus-interface
    dBusInterface = new QDBusInterface(MCE_SERVICE,
                                       MCE_REQUEST_PATH,
                                       MCE_REQUEST_IF,
                                       dBusConnection,
                                       this);

    dBusConnection.connect(MCE_SERVICE,
                           MCE_SIGNAL_PATH,
                           MCE_SIGNAL_IF,
                           MCE_DISPLAY_SIG,
                           this,
                           SLOT(displayStateChanged(const QDBusMessage &)));

    /* dBusInterface->callWithCallback(MCE_DISPLAY_STATUS_GET,
                                    QList<QVariant>(),
                                    this,
                                    SLOT(setDisplayState(QString)),
                                    SLOT(displayStateError(QDBusError)));
                                    */
}

// Handles display state changing
void MCE::displayStateChanged(const QDBusMessage &message)
{
    QString state = message.arguments().at(0).toString();
    // setDisplayState(state);
    emit sigDisplayStateChanged(state);
}

void MCE::displayStateError(const QDBusError &)
{

}

void MCE::setDisplayState(const QString &)
{
//    if (!state.isEmpty()) {
//        if (state == MCE_DISPLAY_ON_STRING)
//            ;  // Display on
//        else if (state == MCE_DISPLAY_OFF_STRING)
//            ;  // Display off
//    }
}
