/*
 * This file is part of the Liquid project.
 * It is error handler, which processed specific errors of our application
 * and returns result to user.
 *
 * Copyright (C) 2009 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2009 Volkov A.A. <volkov@cs.karelia.ru>
 * Copyright (C) 2009 Dmitriev V.V. <vdmitrie@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "error_handler/errorhandler.h"
#include "error_handler/errors.h"

ErrorHandler::ErrorHandler(QWidget *parent) :
        QWidget(parent)
{
}

// Handler for all errors
void ErrorHandler::returnError(int code) {
    switch(code) {
        case ACC_OPEN_ERROR :
            showError("Error occured while opening accelerometer file.", "Acclerometer will be disabled.");
            emit accFatalError();
            break;
        case PAINTER_PIXMAP_ERROR :
            showError("Error occured while drawing pixmap for drop.", QString::null);
            break;
        case ACC_TURNON_ERROR :
            showError("Error occured in activating accelerometer mode.", QString::null);
            break;
        case ACC_TURNOFF_ERROR :
            showError("Error occured in disabling accelerometer mode.", QString::null);
            break;
        case UI_SAVEFILE_ERROR :
            showError("Error while saving image.",
                      "May be this file is only for reading. Try to save it with another name.");
            break;
    }
    return;
}

// Shows error message
void ErrorHandler::showError(const QString error, const QString info) {
    QMessageBox msgBox;
    msgBox.setText(error);
    if(!info.isEmpty())
        msgBox.setInformativeText(info);
    msgBox.setStandardButtons(QMessageBox::Ok);
    msgBox.exec();
    return;
}
