/*
 * This file is part of the Liquid project.
 * It reads and processes data from accelerometer. After data
 * is processed, it generates a signal, which Accelerometer class handles.
 *
 * Copyright (C) 2009 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2009 Volkov A.A. <volkov@cs.karelia.ru>
 * Copyright (C) 2009 Dmitriev V.V. <vdmitrie@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "accelerometer/devorientation.h"
#include <math.h>
#include <error_handler/errors.h>
#include <QDebug>
#include <QTimer>
#include <QFile>
#include <QTextStream>
#include <QStringList>
#include <QtDBus>
#include <math.h>

#define INTERVAL 20
#define MCE_SERVICE "com.nokia.mce"
#define MCE_REQUEST_PATH "/com/nokia/mce/request"
#define MCE_REQUEST_IF "com.nokia.mce.request"
#define MCE_DEVICE_ORIENTATION_GET "get_device_orientation"

// Constructor
devOrientation::devOrientation(ErrorHandler *errorHandler)
{
    eh = new ErrorHandler;
    eh = errorHandler;
    timerID = startTimer(INTERVAL);
}

void devOrientation::timerEvent(QTimerEvent *) {
    QDBusMessage msg = QDBusMessage::createMethodCall(MCE_SERVICE,
                                                      MCE_REQUEST_PATH,
                                                      MCE_REQUEST_IF,
                                                      MCE_DEVICE_ORIENTATION_GET);

    bool sent = QDBusConnection::systemBus().callWithCallback(msg, this,
                                                              SLOT(mceOrientationSlot(QString, QString, QString, int, int, int)));
}

void devOrientation::mceOrientationSlot(const QString &rotation, const QString &stand, const QString &face, int x, int y, int z) {
  fx = x / 100;
  fy = y / 100;
  fz = z / 100;

  emit dataProcessed(QVector3D(-fx, -fy ,-fz));
}

void devOrientation::stopTimer() {
    killTimer(timerID);
}


