/*
 * This file is part of the Liquid project.
 * It is header file of class DevOrientation, which reads and processes
 * data from accelerometer.
 *
 * Copyright (C) 2009 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2009 Volkov A.A. <volkov@cs.karelia.ru>
 * Copyright (C) 2009 Dmitriev V.V. <vdmitrie@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
//! An Accelerometer module.
/*!
  This class gets a data from accelerometer and processes it.
*/

#ifndef DEVORIENTATION_H
#define DEVORIENTATION_H

#include <QWidget>
#include <QThread>
#include <QVector3D>
#include <QString>
#include <error_handler/errorhandler.h>

#define G 9.8
#define PI 3.141592653589

class devOrientation : public QWidget
{
  Q_OBJECT

public:
    ErrorHandler *eh;
    //! A constructor.
    devOrientation(ErrorHandler *errorHandler = 0);
    //! A stub for accelerometer.
    /*!
      If application is running on Windows, then this function
      generates coordinates instead of getting it from sensor.
    */
    QString generateCoords();
    /*!
      Disables reading data from accelerometer sensor.
      Returns true if success.
      \param stop - true - disable reading data, false - activate reading.
    */
    bool stopTimer(bool stop);    

public slots:
    //! Slot which triggers when timeout of m_timer is expired.
    /*!
      Gets data from accelerometer by reading /sys/class/i2c-adapter/i2c-3/3-001d/coord
      and saves it in devOrientation::data.
    */
    void getXYZ();
    //! Slot which triggers when data from accelerometer is gotten.
    /*!
      It splits a value of acceleration from accelerometer on 3 axises.
    */
    void process_data();

signals:
    //! Signal, which generates when acceleration is splitted on 3 axises.
    void dataProcessed(QVector3D);

private:
    QString data; /*!< Contains a string with values of acceleration from sensor. */
    QString x; /*!< A value of acceleration on the X axis. */
    QString y; /*!< A value of acceleration on the Y axis. */
    QString z; /*!< A value of acceleration on the Z axis. */
    QTimer *m_timer; /*!< A timer which sets the delay at which Accelerometer module gets a data from sensor. */

    int m_counter; /*!< Counter for generating coords. */
};

#endif // DEVORIENTATION_H
