// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>
		
		
void liqirc_sendserv(liqcell *liqirc,char *str, ...);



// messagemanage is actually chanmanage
// it holds everything for a single chan
// whether a public chan or a privte conversation

// the irc server exists in the parent list and messages are bubbled into the correct component as required.

		
//#####################################################################
//#####################################################################
//##################################################################### messagemanage :: by gary birkett
//#####################################################################
//#####################################################################
		
/**	
 * messagemanage_liqirc_line_recv a new line came in from the server.
 */	
static int messagemanage_liqirc_line_recv(liqcell *self,char *newline, liqcell *messagemanage)
{
	// a new line has come in from the irc server
	liqcell *userlist1 = liqcell_child_lookup(messagemanage, "userlist1");
	liqcell *messagelist1 = liqcell_child_lookup(messagemanage, "messagelist1");
	liqcell *txtmessage = liqcell_child_lookup(messagemanage, "txtmessage");
	liqcell *cmdsubmit = liqcell_child_lookup(messagemanage, "cmdsubmit");
	liqcell *title = liqcell_child_lookup(messagemanage, "title");
	
	liqcell *liqirc1 = liqcell_child_lookup(messagemanage, "liqirc1");
	//liqapp_log("messagemanage_liqirc_line_recv adding");
	
	messagelist_additem(messagelist1, "00:00", "lcuk", newline );

	return 0;
}
		
/**	
 * messagemanage widget refresh, all params set, present yourself to the user.
 */	
static int messagemanage_refresh(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	// there might be an OS level variable called filter
	// it should be set and adjusted correctly prior to calling this routine
	// you should do your best to account for this filter in any way you see fit
	return 0;
}


/**	
 * messagemanage dialog_open - the user zoomed into the dialog
 */	
static int messagemanage_dialog_open(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * messagemanage dialog_close - the dialog was closed
 */	
static int messagemanage_dialog_close(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * messagemanage widget shown - occurs once per lifetime
 */	
static int messagemanage_shown(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * messagemanage mouse - occurs all the time as you stroke the screen
 */	
static int messagemanage_mouse(liqcell *self, liqcellmouseeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * messagemanage click - occurs when a short mouse stroke occured
 */	
static int messagemanage_click(liqcell *self, liqcelleventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * messagemanage keypress - the user pressed a key
 */	
static int messagemanage_keypress(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * messagemanage keyrelease - the user released a key
 */	
static int messagemanage_keyrelease(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * messagemanage paint - being rendered.  use the vgraph held in args to do custom drawing at scale
 */	
//static int messagemanage_paint(liqcell *self, liqcellpainteventargs *args,liqcell *context)
//{
//	// big heavy event, use sparingly
//	return 0;
//}
/**	
 * messagemanage dynamic resizing
 */	
static int messagemanage_resize(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	float sx=((float)self->w)/((float)self->innerw);
	float sy=((float)self->h)/((float)self->innerh);
	
	liqcell *userlist1 = liqcell_child_lookup(self, "userlist1");
	liqcell *messagelist1 = liqcell_child_lookup(self, "messagelist1");
	liqcell *txtmessage = liqcell_child_lookup(self, "txtmessage");
	liqcell *cmdsubmit = liqcell_child_lookup(self, "cmdsubmit");
	liqcell *title = liqcell_child_lookup(self, "title");
	liqcell *liqirc1 = liqcell_child_lookup(liqirc1, "liqirc1");
	liqcell_setrect_autoscale( userlist1, 698,38, 102,384, sx,sy);
	liqcell_setrect_autoscale( messagelist1, 0,38, 696,384, sx,sy);
	liqcell_setrect_autoscale( txtmessage, 56,424, 642,56, sx,sy);
	liqcell_setrect_autoscale( cmdsubmit, 698,424, 102,56, sx,sy);
	liqcell_setrect_autoscale( title, 0,0, 800,38, sx,sy);
	return 0;
}

/**	
 * messagemanage.cmdsubmit clicked
 */	
static int cmdsubmit_click(liqcell *self,liqcelleventargs *args, liqcell *messagemanage)
{
	liqcell *userlist1 = liqcell_child_lookup(messagemanage, "userlist1");
	liqcell *messagelist1 = liqcell_child_lookup(messagemanage, "messagelist1");
	liqcell *txtmessage = liqcell_child_lookup(messagemanage, "txtmessage");
	liqcell *cmdsubmit = liqcell_child_lookup(messagemanage, "cmdsubmit");
	liqcell *title = liqcell_child_lookup(messagemanage, "title");
	
	liqcell *liqirc1 = liqcell_child_lookup(messagemanage, "liqirc1");
	liqapp_log("message.submit adding");
	
	char *msg = liqcell_getcaption(txtmessage);
	
	if(!msg || !*msg)
	{
		// nothing to show or send
		return -1;
	}
	
	messagelist_additem(messagelist1, "00:00", "gary", liqcell_getcaption(txtmessage) );
	
	
	char buf[1024];
	snprintf(buf,sizeof(buf),"PRIVMSG #liqbase-test :%s",liqcell_getcaption(txtmessage) );
	liqirc_sendserv(liqirc1,buf);
	
	
	liqapp_log("message.submit clearing");
	
	liqcell_setcaption(txtmessage,"");
	//textbox_selectall(txtmessage);
	return 0;
}

/**	
 * liqirc1 connect
 */	
static int liqirc1_connect(liqcell *self, liqcelleventargs *args,liqcell *messagemanage)
{
	return 0;
}

/**	
 * liqirc1 line_recv - a line has been recieved
 */	
static int liqirc1_line_recv(liqcell *self, liqcelleventargs *args,liqcell *messagemanage)
{
	//liqcell *cmdsubmit = liqcell_child_lookup(self, "cmdsubmit");
	//liqcell_handlerrun(cmdsubmit,"click",NULL);
	return 0;
}

/**	
 * liqirc1 line_sent - a line has been send
 */	
static int liqirc1_line_sent(liqcell *self, liqcelleventargs *args,liqcell *messagemanage)
{
	return 0;
}

/**	
 * liqirc1 disconnect
 */	
static int liqirc1_disconnect(liqcell *self, liqcelleventargs *args,liqcell *messagemanage)
{
	return 0;
}



/**	
 * txtmessage keypress_enter - the user pressed enter key on this textbox
 */	
static int txtmessage_keypress_enter(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	liqcell *cmdsubmit = liqcell_child_lookup(self, "cmdsubmit");
	liqcell_handlerrun(cmdsubmit,"click",NULL);
	return 0;
}

/**	
 * messagemanage_child_test_seek this function shows how to access members
 */	
	  
static void messagemanage_child_test_seek(liqcell *self)
{	  
	liqcell *userlist1 = liqcell_child_lookup(self, "userlist1");
	liqcell *messagelist1 = liqcell_child_lookup(self, "messagelist1");
	liqcell *txtmessage = liqcell_child_lookup(self, "txtmessage");
	liqcell *cmdsubmit = liqcell_child_lookup(self, "cmdsubmit");
	liqcell *title = liqcell_child_lookup(self, "title");
}	  
/**	
 * create a new messagemanage widget
 */	
liqcell *messagemanage_create()
{
	liqcell *self = liqcell_quickcreatewidget("messagemanage", "form", 800, 480);
	if(!self) {liqapp_log("liqcell error not create 'messagemanage'"); return NULL;  } 


	//############################# liqirc1:liqirc
	liqcell *liqirc1 = liqcell_quickcreatevis("liqirc1", "liqirc_____x", 698, 38, 102, 384);
	liqcell_handleradd_withcontext(liqirc1, "line_recv", messagemanage_liqirc_line_recv,self );
	liqcell_child_append(  self, liqirc1);
	
	// Optimization:  The aim is to REDUCE the number of drawn layers and operations called.
	// Optimization:  use only what you NEED to get an effect
	// Optimization:  Minimal layers and complexity
	// Optimization:  defaults: background, prefer nothing, will be shown through if there is a wallpaper
	// Optimization:  defaults: text, white, very fast rendering
	//############################# userlist1:userlist
	liqcell *userlist1 = liqcell_quickcreatevis("userlist1", "userlist", 698, 38, 102, 384);
	liqcell_child_append(  self, userlist1);
	//############################# messagelist1:messagelist
	liqcell *messagelist1 = liqcell_quickcreatevis("messagelist1", "messagelist", 0, 38, 696, 384);
	liqcell_child_append(  self, messagelist1);
	//############################# txtmessage:textbox
	liqcell *txtmessage = liqcell_quickcreatevis("txtmessage", "textbox", 56, 424, 642, 56);
	liqcell_setfont(	txtmessage, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (33), 0) );
	liqcell_setcaption(txtmessage, "" );
	liqcell_propsets(  txtmessage, "textcolor", "rgb(255,255,0)" );
	liqcell_propsets(  txtmessage, "backcolor", "rgb(0,0,64)" );
	liqcell_propsets(  txtmessage, "bordercolor", "rgb(200,100,100)" );
	liqcell_propseti(  txtmessage, "textalign", 0 );
	liqcell_propseti(  txtmessage, "textaligny", 2 );
	liqcell_handleradd_withcontext(txtmessage, "keypress_enter", txtmessage_keypress_enter,self );
	liqcell_child_append(  self, txtmessage);
	
	
	textbox_selectall(txtmessage);
	
	//############################# cmdsubmit:label
	liqcell *cmdsubmit = liqcell_quickcreatevis("cmdsubmit", "label", 698, 424, 102, 56);
	liqcell_setfont(	cmdsubmit, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (29), 0) );
	liqcell_setcaption(cmdsubmit, "Submit" );
	liqcell_propsets(  cmdsubmit, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  cmdsubmit, "backcolor", "xrgb(0,128,0)" );
	liqcell_propsets(  cmdsubmit, "bordercolor", "rgb(255,255,255)" );
	liqcell_propseti(  cmdsubmit, "textalign",  2 );
	liqcell_propseti(  cmdsubmit, "textaligny", 2 );
	liqcell_handleradd_withcontext(cmdsubmit, "click", cmdsubmit_click, self );
	liqcell_child_append(  self, cmdsubmit);
	//############################# title:label
	liqcell *title = liqcell_quickcreatevis("title", "label", 0, 0, 800, 38);
	liqcell_setfont(	title, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (24), 0) );
	liqcell_setcaption(title, "liqtactoe" );
	liqcell_propsets(  title, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  title, "backcolor", "xrgb(0,64,64)" );
	liqcell_propseti(  title, "textalign", 0 );
	liqcell_child_append(  self, title);
	liqcell_propsets(  self, "backcolor", "rgb(0,0,0)" );
	liqcell_handleradd_withcontext(self, "refresh", messagemanage_refresh ,self);
	liqcell_handleradd_withcontext(self, "shown", messagemanage_shown ,self);
	liqcell_handleradd_withcontext(self, "resize", messagemanage_resize ,self);
	//liqcell_handleradd_withcontext(self, "keypress", messagemanage_keypress,self );
	//liqcell_handleradd_withcontext(self, "keyrelease", messagemanage_keyrelease ,self);
	liqcell_handleradd_withcontext(self, "mouse", messagemanage_mouse,self );
	liqcell_handleradd_withcontext(self, "click", messagemanage_click ,self);
	//liqcell_handleradd_withcontext(self, "paint", messagemanage_paint ,self); // use only if required, heavyweight
	liqcell_handleradd_withcontext(self, "dialog_open", messagemanage_dialog_open ,self);
	liqcell_handleradd_withcontext(self, "dialog_close", messagemanage_dialog_close ,self);
	return self;
}

