

#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqfont.h>
#include <liqbase/liqsketchfont.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>
#include <liqbase/liqapp_prefs.h>
#include <liqbase/vgraph.h>
#include "liqdoc.h"

#include <X11/keysym.h>



#include "liqbookprogress.h"

//#####################################################################
//#####################################################################
//##################################################################### liqbookreader :: by gary birkett
//#####################################################################
//#####################################################################

	static int liqbookreader_paint_selfrotate(liqcell *self, liqcellpainteventargs *args, struct doc *doc)
	{
		
		
		// the body contains the offset we need to render at
		// uber render, GOGOGO!
		liqcell *body = liqcell_child_lookup(self, "body");
		
		//if( -liqcell_gety(body) + liqcell_geth(body)   )
		//liqcell_setpos(body, liqcell_getx(body)-10,liqcell_getx(body) );
		liqcell_setpos(body, liqcell_getx(body),liqcell_gety(body)-1 );
		
		//doc.renderfont=font;
		//args->graph
		//int		vgraph_setfont(        			vgraph *self, liqfont *font);			//  char *fontname, int fontsize, int fontattributes
		//int		vgraph_setpencolor(    			vgraph *self, vcolor pencolor );
		//int		vgraph_drawtext(       			vgraph *self, int x, int y, char *text        );
		//vgraph_setfont(args->graph,      doc->renderfont);
		//vgraph_setpencolor( args->graph, vcolor_YUV(255,128,128) );
		
		
		
		

		static liqimage *img = NULL;
		if(img==NULL) img = liqimage_newatsize(480,800,0);
		
		liqcliprect *cr = liqcliprect_newfromimage(img);
		//liqcliprect_drawtext(cr,doc->displayfont,0,y,dline->linedata);
		
		//xsurface_drawrectwash_uv(img,0,0,480,800,128,128);
		liqcliprect_drawclear(cr,0,128,128);
		
		struct docline *dline = doc->linefirst;
		int y=0;
		int h=0;
		int vt = -liqcell_getx(body);
		int vb = vt + liqcell_getw(self);
		int tmp=0;
		while(dline)
		{
			h=dline->formath;
			//liqapp_log("huh %d %d,  vt=%d vb=%d",y,h,vt,vb);
			if(y+h > vt)
			{
				//liqapp_log("tmp %d",tmp);
				//vgraph_drawtext(args->graph, y-vt, 0,dline->linedata  );
				liqcliprect_drawtext(cr,doc->renderfont,0,y-vt,dline->linedata);
				//liqcliprect_drawtext_color(cr,doc->renderfont,0,y-vt,dline->linedata,rand()%128,rand()%255,rand()%255);
				if(y>vb) break;
			}
			tmp++;
			
			y+=h;
			dline=dline->linknext;
		}
		
		
		liqimage_rotate( liqcanvas_getsurface(), img, 90 );
		
		
		liqcliprect_release(cr);		
		//liqimage_release(img);
		
		
		
		//liqcell_setdirty(self,1);
		return 1;
	}






	static int liqbookreader_paint(liqcell *self, liqcellpainteventargs *args, struct doc *doc)
	{
		
		// the body contains the offset we need to render at
		// uber render, GOGOGO!
		liqcell *body = liqcell_child_lookup(self, "body");
		
		
		//if( -liqcell_gety(body) + liqcell_geth(body)   )
		
		//liqcell_setpos(body, liqcell_getx(body)-10,liqcell_getx(body) );
		
		
		if(liqcell_propgeti(self,"autoscroll_inuse",0)==1)
		{
			liqcell_setpos(body, liqcell_getx(body),liqcell_gety(body)-1 );
			liqcell_setdirty(self,1);
		}
		
		
		//doc.renderfont=font;
		//args->graph
		//int		vgraph_setfont(        			vgraph *self, liqfont *font);			//  char *fontname, int fontsize, int fontattributes
		//int		vgraph_setpencolor(    			vgraph *self, vcolor pencolor );
		//int		vgraph_drawtext(       			vgraph *self, int x, int y, char *text        );
		vgraph_setfont(args->graph,      doc->renderfont);
		vgraph_setpencolor( args->graph, vcolor_YUV(255,128,128) );
		struct docline *dline = doc->linefirst;
		int y=0;
		int h=0;
		int vt = -liqcell_gety(body);
		int vb = vt + liqcell_geth(self);
		int tmp=0;
		while(dline)
		{
			h=dline->formath;
			//liqapp_log("huh %d %d,  vt=%d vb=%d",y,h,vt,vb);
			if(y+h > vt)
			{
				//liqapp_log("tmp %d",tmp);
				vgraph_drawtext(args->graph, 0,y-vt,dline->linedata  );
				if(y>vb) break;
			}
			tmp++;
			
			y+=h;
			dline=dline->linknext;
		}
		
		//
		return 1;
	}










int liqbookreader_getbookfontsize()
{
		int edfontsize;
		char * t=NULL;
		if((t=liqapp_pref_getvalue("book_fontsize")) && (*t) && (isdigit(*t)))
		{
			edfontsize=atoi(t);
			liqapp_log("liqbookreader_getbookfontsize arg fontsize = %d, '%s'",edfontsize,t);
		}
		else
		{
			edfontsize=40;
			liqapp_log("liqbookreader_getbookfontsize def fontsize = %d",edfontsize);
		}
		if(edfontsize<8)edfontsize=8;
		if(edfontsize>144)edfontsize=144;
		liqapp_log("liqbookreader_getbookfontsize act fontsize = %d",edfontsize);
		return edfontsize;
}





/**	
 * liqbookreader_cover keypress - the user pressed a key
 */	
static int liqbookreader_cover_keypress(liqcell *self, liqcellkeyeventargs *args,struct doc *doc)
{
	liqcell *body = liqcell_child_lookup(self, "body");
	
	int font_height = liqfont_textheight(doc->renderfont);
	
	int book_totalheight=body->h;
	int page_topstart=-body->y;
	int page_lineviewcount=self->h/font_height;
	int page_topmax=book_totalheight-canvas.pixelheight;
	
	
	if(args->keycode==113)		// q
	{
		liqapp_pref_setvalue_printf( "book_fontsize", "%i", liqbookreader_getbookfontsize()-2 );
		liqapp_prefs_save();
		liqcell_handlerrun(self,"refresh",NULL);
		// smaller font
	}
	else
	if(args->keycode==119)		// w
	{
		
		liqapp_pref_setvalue_printf( "book_fontsize", "%i", liqbookreader_getbookfontsize()+2 );
		liqapp_prefs_save();
		liqcell_handlerrun(self,"refresh",NULL);
		// bigger font
	}
	else
	if(args->keycode==XK_Left || args->keycode==XK_Down)
	{
		// move back a page
		page_topstart = (((page_topstart - self->h)/ font_height)+1)*font_height;
		if(page_topstart<0)page_topstart=0;
		liqcell_setpos(body, liqcell_getx(body), -page_topstart );
		liqcell_setdirty(self,1);
	}
	else
	if(args->keycode==XK_Right || args->keycode==XK_Up)
	{
		// move forward a page
		page_topstart = (((page_topstart + self->h)/ font_height))*font_height;
		if(page_topstart>page_topmax)page_topstart=page_topmax;
		liqcell_setpos(body, liqcell_getx(body), -page_topstart );
		liqcell_setdirty(self,1);
	}
	else
	if(args->keycode==32)
	{
		// autoscroll..
		if(liqcell_propgeti(self,"autoscroll_inuse",0)==1)
		{
			// its in use, need to disable it
			liqcell_propseti(self,"autoscroll_inuse",0);
		}
		else
		{
			// not in use, need to enable it
			liqcell_propseti(self,"autoscroll_inuse",1);
		}
	}
	else
	{
		liqapp_log("liqbookreader: Unknown keycode %d",args->keycode);
	}
	return 0;
}
/**	
 * liqbookreader_cover keyrelease - the user released a key
 */	
static int liqbookreader_cover_keyrelease(liqcell *self, liqcellkeyeventargs *args,struct doc *doc)
{
	return 0;
}




/**	
 * liqbookreader refresh - rebuild book details
 */	
static int liqbookreader_refresh(liqcell *self, liqcelleventargs *args,struct doc *doc)
{

	
		int err=0;
		
		char *bookfilename = liqcell_propgets(self,"book_filename",NULL);
		
		//================================================== get and process the fontsize
		int edfontsize=liqbookreader_getbookfontsize();
		liqapp_log("liqbookreader_run act fontsize = %d",edfontsize);
		
		//=================================================== now, open the font
		
		liqfont *font = liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (edfontsize), 0);


		if(!font)
		{
			{ return liqapp_warnandcontinue(-1,"liqbookreader_run couldnt open font"); }						
		}
		
		//liqfont_setscale(font,1,1);




		//=================================================== initialize the bookprogress

		liqbookprogress_shutdown();
		liqbookprogress_startup();


		if(doc->renderfont)
		{
			liqfont_cache_release(doc->renderfont);
			doc->renderfont=NULL;
		}
		
		doc->renderfont=font;
		doc->rendermarginright=480;
		//doc.rendermarginbottom=99999999;
	
		err=doc_initfromfilename(doc,bookfilename);
		
		
		if(err)
		{
			{ return liqapp_warnandcontinue(-1,"liqbookreader_run couldnt open doc"); }						
		}
		
		liqcell *body = liqcell_child_lookup(self, "body");
		
		
		liqcell_setrect(body, 0,0, 480,doc->rendertoth);

		
		unsigned int sfl=0;
		unsigned int sfu=0;
		if(liqbookprogress_startreading_lookupposition(bookfilename,&sfl,&sfu))
		{
			//
			if(sfu>sfl-(self->h))sfu=sfl-self->h;
			liqapp_log("book opening, sfu=%d, sfl=%d",sfu,sfl);
			if(body->h>0 && sfl>0)
				liqcell_setpos(body,0, -( sfu * (body->h/128) / (sfl/128)));
				
			liqapp_log("book opening, body->y=%d, body->h=%d",body->y,body->h);
				
		}
		
		
			

	return 0;

}







int liqbookreader_run(char *bookfilename)
{
	liqcell *self = liqcell_quickcreatewidget("liqbookreader","form", 480,800);

	if(self)
	{

		liqcell_propsets(self,"book_filename",bookfilename);
		//char *bookfilename = liqcell_propgets(self,"book_filename",NULL);


		int err=0;
		
		//char *bookfilename = liqcell_propgets(self,"bookfilename",NULL);
		
		//================================================== get and process the fontsize
		int edfontsize=liqbookreader_getbookfontsize();
		
		liqapp_log("liqbookreader_run act GB fontsize = %d",edfontsize);
		
		//=================================================== now, open the font
		
		liqfont *font = liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (edfontsize), 0);


		if(!font)
		{
			{ return liqapp_warnandcontinue(-1,"liqbookreader_run couldnt open font"); }						
		}
		
		//liqfont_setscale(font,1,1);




		//=================================================== initialize the bookprogress

		liqbookprogress_shutdown();
		liqbookprogress_startup();






		//=================================================== open the book now 

		// grab the file and process it :)
		struct doc doc;
		doc.renderfont=NULL;
		
		
		doc.renderfont=font;
		doc.rendermarginright=480;
		//doc.rendermarginbottom=99999999;
	


		err=doc_initfromfilename(&doc,bookfilename);
		
		
		if(err)
		{
			{ return liqapp_warnandcontinue(-1,"liqbookreader_run couldnt open doc"); }						
		}
			
		
	//	// change to rotated now we have weighed it
	//	liqfont_release(font);
	//	font = liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (edfontsize), 90);
	//	doc.renderfont=font;
		
		
		liqcell *body = liqcell_quickcreatevis("body",NULL,0 ,0, 480,doc.rendertoth  );
		liqcell_handleradd(body,    "mouse",   liqcell_easyhandler_kinetic_mouse );
		liqcell_child_insert( self, body );
		
		
		//liqcell_handleradd_withcontext(body,    "paint", widget_paint,self);
		
		
		unsigned int sfl=0;
		unsigned int sfu=0;
		if(liqbookprogress_startreading_lookupposition(bookfilename,&sfl,&sfu))
		{
			//
			if(sfu>sfl-(self->h))sfu=sfl-self->h;
			liqapp_log("book opening, sfu=%d, sfl=%d",sfu,sfl);
			if(body->h>0 && sfl>0)
				liqcell_setpos(body,0, -( sfu * (body->h/128) / (sfl/128)));
				
			liqapp_log("book opening, body->y=%d, body->h=%d",body->y,body->h);
				
		}
		
		
		// now, create the booklines or generate on the fly...
	
		//########################################## simple style..
		/*
		struct docline *dline = doc.linefirst;
		int y=0;
		int usedcount=0;
		while(dline)
		{

			// no paragraph grouping, very slow for >10k lines (normal book size)
			liqcell *scrline = liqcell_quickcreatevis(dline->linedata,NULL,0 ,y,   800,dline->formath);
			liqcell_setfont(scrline,liqfont_hold(font));
			liqcell_child_insert( body, scrline );
						
			
			y+=dline->formath;
			dline=dline->linknext;
			if(y>4000) break;
			usedcount++;
			
		}
		liqapp_log("liqbookreader added %d out of %d lines",doc.linecount,usedcount);
		*/
		
		//########################################## custom renderer ..
		
		liqcell_handleradd_withcontext(self, "refresh",    (void*)liqbookreader_refresh,          &doc);
		liqcell_handleradd_withcontext(self, "paint",      (void*)liqbookreader_paint,            &doc);
		liqcell_handleradd_withcontext(self, "keypress",   (void*)liqbookreader_cover_keypress,   &doc);
		liqcell_handleradd_withcontext(self, "keyrelease", (void*)liqbookreader_cover_keyrelease, &doc);
		
		liqcell_easyrun(self);
		
		
		sfl = body->h;
		sfu = -body->y;
		liqapp_log("book closing, sfu=%d, sfl=%d",sfu,sfl);
		liqbookprogress_finishedreading_storeposition(bookfilename,sfl,sfu);
	}
	
	
	liqcell_release(self);
	return 0;
	//return self;
}
