// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_easyrun.h>


liqcell *liqbookreader_create();
liqcell *liqbooklist_create();
int liqbookreader_run(char *bookfilename);



	
/**	
 * liqbook widget refresh, all params set, present yourself to the user.
 */	
static int liqbook_refresh(liqcell *self,liqcelleventargs *args, void *context)
{
	// there might be an OS level variable called filter
	// it should be set and adjusted correctly prior to calling this routine
	// you should do your best to account for this filter in any way you see fit
	return 0;
}

/**	
 * liqbook.bookx clicked
 */	
static int bookx_click(liqcell *self,liqcelleventargs *args, liqcell *liqbook)
{
	char *bookname = liqcell_propgets(self,"bookname",NULL);
	if(bookname && *bookname)
	{
		liqbookreader_run(bookname);
	}
	else
	{
	//	liqbookreader_run("/usr/share/liqbase/liqbook/media/liqbook.body.txt");
	}
	return 0;
}

/**	
 * liqbook.book_continuereading clicked
 */	
static int book_continuereading_click(liqcell *self,liqcelleventargs *args, liqcell *liqbook)
{
	char *bookname = liqcell_propgets(self,"bookname",NULL);
	if(bookname && *bookname)
	{
		liqbookreader_run(bookname);
	}
	else
	{
		liqbookreader_run("/usr/share/liqbase/liqbook/media/liqbook.body.txt");
	}
	return 0;
}

/**	
 * create a new liqbook widget
 */	
liqcell *liqbook_create()
{
	
	// Smile, it's not every day you get to see things differently.
	
	liqcell *self = liqcell_quickcreatewidget("liqbook", "form", 480,800);
	if(!self) {liqapp_log("liqcell error not create 'liqbook'"); return NULL;  } 

{
	//############################# bookx:commandbutton
	liqcell *bookx = liqcell_quickcreatevis("bookx", "label", 40, 70, 400, 110);
	liqcell_setfont(	bookx, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (40), 0) );
	liqcell_setcaption(bookx, "Going the extra Smile!" );
	liqcell_handleradd_withcontext(bookx, "click", bookx_click, self );
	liqcell_propseti(  bookx, "textalign", 2 );
	liqcell_propseti(  bookx, "textaligny", 2 );
	liqcell_child_append(  self, bookx);
}





{
	//############################# bookx:commandbutton
	liqcell *bookx = liqcell_quickcreatevis("bookx", "commandbutton", 40, 180, 400, 80);
	liqcell_setfont(	bookx, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (36), 0) );
	liqcell_setcaption(bookx, "Sketch Fonts - The Idea" );
	liqcell_propsets(  bookx, "backcolor", "rgb(15,35,15)" );
	liqcell_propsets(  bookx, "bookname", "/usr/share/liqbase/liqbook/media/liqbook.sketchfont.idea.txt" );
	liqcell_handleradd_withcontext(bookx, "click", bookx_click, self );
	liqcell_propseti(  bookx, "textalign", 2 );
	liqcell_propseti(  bookx, "textaligny", 2 );
	liqcell_propsets(  bookx, "bordercolor", "rgb(255,255,255)" );
	liqcell_child_append(  self, bookx);
}



{
	//############################# bookx:commandbutton
	liqcell *bookx = liqcell_quickcreatevis("bookx", "commandbutton", 40, 300, 400, 80);
	liqcell_setfont(	bookx, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (36), 0) );
	liqcell_setcaption(bookx, "Smile - The Idea" );
	liqcell_propsets(  bookx, "backcolor", "rgb(15,35,15)" );
	liqcell_propsets(  bookx, "bookname", "/usr/share/liqbase/liqbook/media/liqbook.smile.idea.txt" );
	liqcell_handleradd_withcontext(bookx, "click", bookx_click, self );
	liqcell_propseti(  bookx, "textalign", 2 );
	liqcell_propseti(  bookx, "textaligny", 2 );
	liqcell_propsets(  bookx, "bordercolor", "rgb(255,255,255)" );
	liqcell_child_append(  self, bookx);
}
{
	//############################# bookx:commandbutton
	liqcell *bookx = liqcell_quickcreatevis("bookx", "commandbutton", 40, 420, 400, 80);
	liqcell_setfont(	bookx, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (25), 0) );
	liqcell_setcaption(bookx, "Sketch Fonts - Implementation" );
	liqcell_propsets(  bookx, "backcolor", "rgb(15,15,15)" );
	liqcell_propsets(  bookx, "bookname", "/usr/share/liqbase/liqbook/media/liqbook.sketchfont.implementation.txt" );
	liqcell_handleradd_withcontext(bookx, "click", bookx_click, self );
	liqcell_propseti(  bookx, "textalign", 2 );
	liqcell_propseti(  bookx, "textaligny", 2 );
	liqcell_propsets(  bookx, "bordercolor", "rgb(255,255,255)" );
	liqcell_child_append(  self, bookx);
}
{
	//############################# bookx:commandbutton
	liqcell *bookx = liqcell_quickcreatevis("bookx", "commandbutton", 40, 540, 400, 80);
	liqcell_setfont(	bookx, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (25), 0) );
	liqcell_setcaption(bookx, "Smile - Implementation" );
	liqcell_propsets(  bookx, "backcolor", "rgb(15,15,15)" );
	liqcell_propsets(  bookx, "bookname", "/usr/share/liqbase/liqbook/media/liqbook.smile.implementation.txt" );
	liqcell_handleradd_withcontext(bookx, "click", bookx_click, self );
	liqcell_propseti(  bookx, "textalign", 2 );
	liqcell_propseti(  bookx, "textaligny", 2 );
	liqcell_propsets(  bookx, "bordercolor", "rgb(255,255,255)" );
	liqcell_child_append(  self, bookx);
}

{
	//############################# bookx:commandbutton
	liqcell *bookx = liqcell_quickcreatevis("bookx", "commandbutton", 40, 660, 400, 80);
	liqcell_setfont(	bookx, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (25), 0) );
	liqcell_setcaption(bookx, "Liqbase Info" );
	liqcell_propsets(  bookx, "backcolor", "rgb(15,15,35)" );
	liqcell_propsets(  bookx, "bookname", "/usr/share/liqbase/liqbook/media/liqbase.info.txt" );
	liqcell_handleradd_withcontext(bookx, "click", bookx_click, self );
	liqcell_propseti(  bookx, "textalign", 2 );
	liqcell_propseti(  bookx, "textaligny", 2 );
	liqcell_propsets(  bookx, "bordercolor", "rgb(255,255,255)" );
	liqcell_child_append(  self, bookx);
}


	//############################# icon:label
	liqcell *icon = liqcell_quickcreatevis("icon", "label", 6, 8, 52, 40);
	liqcell_setfont(	icon, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (12), 0) );
	liqcell_setcaption(icon, "icon" );
	liqcell_propsets(  icon, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  icon, "backcolor", "rgb(0,0,0)" );
	liqcell_propsets(  icon, "bordercolor", "rgb(200,100,100)" );
	
	
	
	liqcell_setsketch(   icon,    liqsketch_newfromfile("/usr/share/liqbase/liqbook/media/liq.20110207_180837.lcuk.smile.me.page"));
	
	liqcell_propseti(  icon, "textalign", 2 );liqcell_propseti(  icon, "textalign", 2 );
	liqcell_child_append(  self, icon);
	
	//############################# title:label
	liqcell *title = liqcell_quickcreatevis("title", "label", 66, 8, 724, 40);
	liqcell_setfont(	title, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (29), 0) );
	liqcell_setcaption(title, "Liqbook - prototype" );
	//liqcell_propsets(  title, "textcolor", "rgb(255,255,255)" );
	//liqcell_propsets(  title, "backcolor", "rgb(0,0,0)" );
	liqcell_propseti(  title, "textalign", 0 );
	liqcell_child_append(  self, title);
	//liqcell_setvisible(title,0);
 
	//liqcell_propsets(  self, "backcolor", "rgb(0,0,0)" );
	liqcell_handleradd(self, "refresh", liqbook_refresh );
	return self;
}








//#####################################################################
//#####################################################################
//##################################################################### main :)
//#####################################################################
//#####################################################################

// this is only used when liqbook is compiled as a standalone binary
// otherwise it can be constructed as a widget and exist with exactly the same lifespan

static void liqcell_easyrun_internal(liqcell *dialog)
{
	 if(0!=liqcanvas_init(800,480, 1))
	 {
		  liqapp_errorandfail(-1,"liqbook canvas Init");
		  //closeall();
		  return -1;
	 }
	 liqcell_easyrun( dialog );
	 liqcanvas_close();
}

int main (int argc, char* argv[])
{
	 if(liqapp_init(	argc,argv ,"liqbook" ,"0.0.1") != 0)
	 {
		  { return liqapp_errorandfail(-1,"liqbook liqapp_init failed"); }
	 }
	 
int rotflip=0;
	 if( 0 == atoi(liqapp_pref_getvalue_def("forcerotation","0")) )
	 {
		rotflip=1;
		liqapp_pref_setvalue("forcerotation","1");
		liqapp_prefs_save();
	 }
		
	 
	 liqcell *self = liqbook_create();
	 liqcell_propseti(self,"easyrun_hidetools",1);
	 liqcell_easyrun_internal(self);
	 liqcell_release(self);
	 liqapp_close();
	if(rotflip)
	 {
		liqapp_pref_setvalue("forcerotation","0");
		liqapp_prefs_save();
	 }
	 return 0;
}

