/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0

Item {
    id: root
    width: parent.width
    height: rootColumn.height + 20

    signal clicked

    Rectangle{
            id: border
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.margins: 10
            height: parent.height
            color: palette.dark
            radius: 10

            MouseArea{
                anchors.fill: parent
                onClicked: root.clicked()

            }

            Column{
                    id: rootColumn
                    anchors.left: parent.left
                    anchors.right: parent.right
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.margins: 10
                    Text {font.pixelSize: 22;  wrapMode: Text.Wrap; width: parent.width; color: palette.text; text: firstName+" "+lastName}
                    Text {font.pixelSize: 20;  wrapMode: Text.Wrap; width: parent.width; color: palette.text; text: recommendationType}

            }
    }


}
