/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "../components"

Item{
	id: root
	height: button.height
	width: parent.width


	property bool shown: false
	property alias text: label.text

	Button{
		id: button
		width: parent.width
		height: image.height +20
		onClicked: shown = !shown

		Image {
			id: image
			source: "qrc:///qml/images/arrow-down-small.png"
			anchors.right: parent.right
			anchors.margins: 20
			anchors.verticalCenter: parent.verticalCenter
			Behavior on rotation { NumberAnimation{duration: 250}}
		}

		Text{
			id: label
			color: palette.text
			font.pixelSize: 25
			anchors.left: parent.left
			anchors.verticalCenter: parent.verticalCenter
			anchors.leftMargin: 10
		}
	}

	states: [
		State {
			name: "shown"
			when: shown
			PropertyChanges {target: image; rotation: 180}
		}
	]


}
