/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/

#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QGraphicsObject>
#include "qmlapplicationviewer.h"

#include "authorizer.h"
#include "settings.h"
#include "linkedinapi.h"
#include "user.h"
#include "notifier.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

	/*classes designed for use in qml*/
	Authorizer auth;
	Settings settings;
	LinkedInAPI api;
	User user;
	Notifier notifier;

    QmlApplicationViewer viewer;
    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
	viewer.rootContext()->setContextProperty("OAuth", &auth);
	viewer.rootContext()->setContextProperty("Settings", &settings);
	viewer.rootContext()->setContextProperty("API", &api);
	viewer.rootContext()->setContextProperty("User", &user);
	viewer.rootContext()->setContextProperty("Notifier", &notifier);
	viewer.setMainQmlFile(QLatin1String("qml/linkedup/main.qml"));

	QObject *rootObject = dynamic_cast<QObject*>(viewer.rootObject());
	QObject::connect(&auth, SIGNAL(authorized()), rootObject, SIGNAL(authorized()));

#ifdef Q_WS_MAEMO_5
	viewer.showFullScreen();
//	viewer.showExpanded();
#else
	viewer.showExpanded();
#endif
    return app.exec();
}
