import QtQuick 1.0



Item {
	id: root
	width: parent.width; height: row.height

	signal clicked(string profileID)
//	property string website: websiteUrl

//	Component.onCompleted: {
//		if(websiteUrl.search("http") < 0){
//			website = "http://" + websiteUrl
//		}
//	}
	Row{
		id: row
		spacing: 10

		Image {
			id: image
			height:  80
			smooth: true
			width: height
			source: squareLogo ? squareLogo : (logoUrl ? logoUrl :"qrc:///qml/images/profile-picture.png" )


			MouseArea{
				anchors.fill: parent
				onClicked: {
					root.clicked(id)
				}
			}
		}

		Column{
			id: column
			width: root.width - image.width
			Text {font.pixelSize: 24; color: palette.text; wrapMode: Text.Wrap; width: column.width; text: name}
			Text {font.pixelSize: 20; color: palette.text; wrapMode: Text.Wrap; width: column.width; text: type}
			Text {font.pixelSize: 20; color: palette.text; wrapMode: Text.Wrap; width: column.width; text: experience}
			Text {font.pixelSize: 20; color: palette.text; wrapMode: Text.Wrap; width: column.width; text: location}

		}


	}



}



