import QtQuick 1.0
import "components"
import "search"
import "profile"
import "home"

/*The home screen in which other screens are launched*/
Window {
	id: window
	width: parent.width
	height: parent.height
	borderTitle: "Home"
	z:100
	isRoot: true

	signal clicked()

        Component.onCompleted: Notifier.notify("Tip: If you don't know what a button does, press and hold it for an explanation!")

        PathView{
            anchors.fill: parent

            model:  HomeModel{}
            delegate: HomeDelegate{}
            path:Path {
                startX: window.width*.5; startY: window.height*.5

                PathAttribute{ name: "opacity"; value: 1}
                PathAttribute{ name: "scale"; value: 1}
                PathAttribute{ name: "z"; value: 1}
                PathQuad {
                    x: window.width*.5 ; y: window.height*.20
                    controlX: window.width+100; controlY: window.height*.35
                }

                PathAttribute{ name: "opacity"; value: .2}
                PathAttribute{ name: "scale"; value: .3}
                PathAttribute{ name: "z"; value: 0}
                PathQuad {
                    x: window.width*.5 ; y: window.height*.5
                    controlX: -100; controlY: window.height*.35
                }


            }

        }


}
