/*
    Copyright 2010 Marcello V. Mansueto <marcello.m@yahoo.com>

    This file is part of lightmeter.

    lightmeter is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    lightmeter is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with lightmeter.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QInputDialog>
#include <QMouseEvent>

#include "mylcdnumber.h"

MyLCDNumber::MyLCDNumber(QWidget * parent) : QLCDNumber(parent) {
    return;
}

void MyLCDNumber::setType(const QStringList& i, const QString& t, const QString& l) {
    items = i;
    title = t;
    label = l;
}

void MyLCDNumber::mouseReleaseEvent ( QMouseEvent * event ) {
    bool ok;
    QString item = QInputDialog::getItem(this, title, label, items, 0, false, &ok);
    if(ok) {
        emit activated(item);
    }
    event->accept();
}
