/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#include <QtGui/QApplication>

#include "qmlapplicationviewer.h"
#include "qmaemo5homescreenadaptor.h"

#include "settingsdlg.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    QmlApplicationViewer viewer;

    viewer.setStyleSheet("background:transparent");
    viewer.setAttribute(Qt::WA_TranslucentBackground);

    viewer.setMainQmlFile(QLatin1String("/opt/lichvietwidget/qml/lichvietwidget/main.qml"));

    /*
    viewer.setFixedWidth(390);
    viewer.setFixedHeight(340);
    */

    QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&viewer);
    adaptor->setSettingsAvailable(true);

    SettingsDlg settingsdlg;

    QObject::connect(adaptor, SIGNAL(settingsRequested()), &settingsdlg, SLOT(showSettingsDialog()));

    viewer.show();

    app.exec();
}
