/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0
import "main.js" as Main

Item {
    id: lichvietwidget

    width: 370
    height: 140

    Rectangle {
        id: lvwidgetrec
        color: "#272020"
        radius: 8
        opacity: 0.7
        anchors.fill: parent
    }

    Rectangle {
        id: rectangle1
        x: 5
        y: 5
        width: 362
        height: 156
        anchors.fill: parent
        radius: 8
        gradient: Gradient {
            GradientStop {
                position: 0
                color: "#f0eef7"
            }
        }
        clip: true
        smooth: true
        z: 0
        anchors.rightMargin: 5
        anchors.bottomMargin: 6
        anchors.leftMargin: 5
        anchors.topMargin: 5
        border.color: "#6382c6"
        border.width: 1
        opacity: 0.7

        Image {
            id: day_left_img
            x: 132
            y: -2
            width: 60
            height: 75
            source: "imgs/1.png"
            visible:true
        }

        Image {
            id: day_right_img
            x: 179
            y: -2
            width: 60
            height: 75
            visible: true
            source: "imgs/0.png"
        }

        Image {
            id: day_center_img
            x: 157
            y: -2
            width: 60
            height: 75
            source: "imgs/4.png"
            visible: true
        }

        Image {
            id: month_right_img
            x: 294
            y: 2
            width: 33
            height: 35
            visible: true
        }

        Image {
            id: month_left_img
            x: 265
            y: 2
            width: 34
            height: 35
            visible: true
        }

        Image {
            id: year_1_img
            x: 235
            y: 32
            width: 35
            height: 35
        }

        Image {
            id: year_2_img
            x: 264
            y: 32
            width: 35
            height: 35
        }

        Image {
            id: year_3_img
            x: 293
            y: 32
            width: 35
            height: 35
        }

        Image {
            id: year_4_img
            x: 322
            y: 32
            width: 35
            height: 35
        }

        Text {
            id: txt_detail
            x: 174
            y: 68
            color: "#0c0a4d"
            text: ""
            anchors.horizontalCenterOffset: 0
            font.family: "Nokia Sans"
            verticalAlignment: Text.AlignTop
            horizontalAlignment: Text.AlignHCenter
            font.pointSize: 16
            textFormat: Text.RichText
            anchors.horizontalCenter: parent.horizontalCenter
        }

        Rectangle {
            id: rectangle2
            x: 4
            y: 7
            width: 131
            height: 56
            color: "#ffffff"
            radius: 8
            border.color: "#000000"

            Text {
                id: txt_thu
                x: 5
                y: 11
                width: 121
                text: ""
                verticalAlignment: Text.AlignTop
                style: Text.Normal
                horizontalAlignment: Text.AlignHCenter
                font.bold: true
                font.pixelSize: 23
                font.family: "Nokia Sans"
            }
        }
    }

    Timer {
        interval: 1000; running: true; repeat: true
        onTriggered: Main.refresh(day_center_img, day_left_img, day_right_img, month_left_img, month_right_img, year_1_img, year_2_img,year_3_img,year_4_img, txt_detail, txt_thu)
    }

}
