/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0
import "main.js" as Main

Item {
    id: lichvietwidget

    width: 370
    height: 235

    Rectangle {
        id: lvwidgetrec
        color: "#272020"
        radius: 8
        opacity: 0.7
        anchors.fill: parent

        Text {
            id: txt_title
            x: 133
            y: 206
            color: "#ffffff"
            text: "Lịch Việt"
            style: Text.Raised
            font.bold: true
            wrapMode: Text.WrapAnywhere
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 18
            font.family: "Tahoma"
        }
    }

    Rectangle {
        id: rectangle1
        x: 5
        y: 5
        width: 362
        height: 196
        anchors.fill: parent
        radius: 8
        gradient: Gradient {
            GradientStop {
                position: 0
                color: "#000000"
            }

            GradientStop {
                position: 0.03
                color: "#f0eef7"
            }
        }
        clip: true
        smooth: true
        z: 0
        anchors.rightMargin: 5
        anchors.bottomMargin: 36
        anchors.leftMargin: 5
        anchors.topMargin: 5
        border.color: "#6382c6"
        border.width: 1
        opacity: 0.9

        Image {
            id: day_left_img
            x: 7
            y: 13
            width: 100
            height: 100
            source: "imgs/1.png"
            visible:false
        }

        Image {
            id: day_right_img
            x: 86
            y: 13
            width: 100
            height: 100
            visible: false
            source: "imgs/4.png"
        }

        Image {
            id: day_center_img
            x: 45
            y: 13
            width: 100
            height: 100
            source: "imgs/4.png"
            visible: false
        }

        Image {
            id: month_right_img
            x: 257
            y: 19
            width: 50
            height: 47
        }

        Image {
            id: month_left_img
            x: 218
            y: 19
            width: 50
            height: 47
        }

        Image {
            id: year_1_img
            x: 179
            y: 59
            width: 50
            height: 47
        }

        Image {
            id: year_2_img
            x: 218
            y: 59
            width: 50
            height: 47
        }

        Image {
            id: year_3_img
            x: 257
            y: 59
            width: 50
            height: 47
        }

        Image {
            id: year_4_img
            x: 296
            y: 59
            width: 50
            height: 47
        }

        Text {
            id: txt_detail
            x: 174
            y: 120
            text: "_"
            anchors.horizontalCenterOffset: 0
            font.family: "Nokia Sans"
            verticalAlignment: Text.AlignTop
            horizontalAlignment: Text.AlignHCenter
            font.pointSize: 16
            textFormat: Text.RichText
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }

    Timer {
        interval: 1000; running: true; repeat: true
        onTriggered: Main.refresh(day_center_img, day_left_img, day_right_img, month_left_img, month_right_img, year_1_img, year_2_img,year_3_img,year_4_img, txt_detail)
    }

}
