/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0
import "amlich-hnd.js" as AmLich
import "amlich-aa98.js" as AmLich98

Item{
    id: amdatetime
    state: "switch_me"
    BorderImage { anchors.centerIn: parent;source: "./img/titlebar.sci"; width: 344+2; height: 234+14; y: +7  }
    Rectangle {
        id: rectangle1
        x: 0
        y: -16
        anchors.centerIn: parent
        width:460
        height: 234
        color: "#19262b"
        radius: 8
        border.color: "#b57e8f"
        visible: true
        opacity:0.9

        Button {
            id: button2
            x: 313
            anchors.right: parent.right; anchors.rightMargin: 8; y: 185; width: 140; height: 40
            text: "OK"
            onClicked: {
                 var lday = lunarday_pathview.currentIndex+1;
                 var lmonth=lunarmonth_pathview.currentIndex+1;
                 var lyear=lunaryear_pathview.currentIndex+1900;

                var lnhuan=0;

                var thangnhuan = -1;

                for (var l=0;l<12;l++)
                    if (lunarmonth_model.get(l).nhuan){
                        thangnhuan = l;
                    }

                 if(lunarmonth_model.get(lunarmonth_pathview.currentIndex).nhuan){
                     lnhuan=1;
                     lmonth=lmonth-1;
                 }

                 if (thangnhuan!=-1 && lunarmonth_pathview.currentIndex> thangnhuan)
                     lmonth-=1;

                var finalSolarDay = AmLich98.convertLunar2Solar(lday,lmonth,lyear,lnhuan,7)

                 LC.reset(finalSolarDay[0],finalSolarDay[1],finalSolarDay[2])
                 screen.calculateLunar( finalSolarDay[0], finalSolarDay[1], finalSolarDay[2])
                 screen.state="mainscreen"
                 screen.refresh()

                 maindatemodel.reset()
                 txtDATEpv.currentIndex =  finalSolarDay[0]-1;

            }
        }

        Button {
            id: button3
            x: 413
            y: 6
            width: 39
            height: 40
            text: "X"
            anchors.rightMargin: 56
            onClicked: {screen.state="mainscreen"}
        }

        Rectangle {
            id: rectangle2
            x: 23
            y: 89
            width: 415
            height: 56
            radius: 9
            gradient: Gradient {
                GradientStop {
                    position: 0
                    color: "#ffffff"
                }

                GradientStop {
                    position: 0.1
                    color: "#7c6969"
                }
            }
            border.color: "#b57e8f"

            Rectangle {
                id:lmk
                x: 207
                y: -39
                width: 198; height: 129
                gradient: Gradient {
                    GradientStop {
                        position: 0.89
                        color: "#148ebe"
                    }

                    GradientStop {
                        position: 0.01
                        color: "#19262b"
                    }

                    GradientStop {
                        position: 0.13
                        color: "#6eb3d5"
                    }

                    GradientStop {
                        position: 1
                        color: "#19262b"
                    }
                }
            }

            /**LUNAR YEAR**/
            Rectangle {
                id:lunaryear_rec
                state: "switch_to_year"
                x: 217
                y: -39
                width: 178; height: 129
                color:"transparent"

                property int index: 0
                onIndexChanged: lunaryear_pathview.currentIndex = lunaryear_rec.index

                Component {
                    id: lunaryear_delegate
                    Column {
                        id: wrapper
                        Text {
                            id: nameText
                            text: name
                            font.pointSize: 16
                            width: lunaryear_rec.width
                            color: PathView.isCurrentItem ? "#FFFFFF" : "grey"
                            verticalAlignment:Text.AlignLeft
                            font.bold: true
                        }
                    }
                }

                PathView {
                    id:lunaryear_pathview
                    anchors.fill: parent
                    model: lunaryear_model
                    delegate: lunaryear_delegate
                     pathItemCount: 3
                     clip: true
                     preferredHighlightBegin: 0.5
                     preferredHighlightEnd: 0.5
                     highlightRangeMode: PathView.StrictlyEnforceRange
                     focus: true
                     path: Path {
                         startX: 90
                         startY: 0
                         PathLine {x: 90; y: lunaryear_rec.height}
                     }

                     onMovementEnded: {
                         //console.log(lunaryear_pathview.currentIndex)
                         AmLich.getYearInfo(lunaryear_pathview.currentIndex+1900);
                         lunarmonth_model.change(lunaryear_pathview.currentIndex+1900, lunarmonth_pathview.currentIndex+1);
                     }
                }
                MouseArea {
                    id:lunaryear_mousearea
                    anchors.fill: parent
                    onClicked: {
                        amdatetime.state="switch_to_year"
                    }
                }
            }

            ListModel {
                id:lunaryear_model
                Component.onCompleted: {
                    init()
                 }

                function init(){
                    for(var i=1900;i<2099;i++){
                        var lunarYear = AmLich.getYearCanChi(i)
                        append({name:i+" ("+lunarYear+")"})
                    }
                }

                function change(YYYY){
                    lunaryear_pathview.currentIndex = YYYY - 1900
                }
            }
            /***/

            /**LUNAR DAY*/
                Rectangle{
                    state:"switch_to_day"
                    id:lunarday_rec
                    x: -20
                    y: -39
                    width: 80; height: 129
                    color:"transparent"

                    property int index: 0
                    onIndexChanged: lunarday_pathview.currentIndex = lunarday_rec.index

                    Component {
                        id: lunarday_delegate
                        Column {
                            id: wrapper

                            Text {
                                id: nameText
                                text: name
                                font.pointSize: 18
                                width: lunarday_rec.width
                                color: PathView.isCurrentItem ? "#FFFFFF" : "grey"
                                verticalAlignment:Text.AlignVCenter
                                font.bold: true
                            }

                        }
                    }

                    PathView {
                        id:lunarday_pathview
                        anchors.fill: parent
                        model: lunarday_model
                        delegate: lunarday_delegate
                         pathItemCount: 1
                         clip: true
                         preferredHighlightBegin: 0.5
                         preferredHighlightEnd: 0.5
                         highlightRangeMode: PathView.StrictlyEnforceRange
                         focus: true
                         path: Path {
                             startX: 90
                             startY: 0
                             PathLine {x: 90; y: lunarday_rec.height}
                         }
                    }

                    MouseArea {
                        id:lunarday_mousearea
                        anchors.fill: parent
                        onClicked: {
                            amdatetime.state="switch_to_day"
                        }
                    }

                }

                ListModel {
                    id:lunarday_model
                    Component.onCompleted: {
                        for(var i=1;i<=30;i++)
                            append({name:i})
                    }

                    function change(MM,DD){

                        while(lunarday_model.count>0){
                            lunarday_model.remove(lunarday_model.count-1)
                        }


                        var daystotal = AmLich.RMM[MM-1];

                        if(lunarmonth_model.get(MM-1).nhuan){

                                for (var i=1;i<=AmLich.LML;i++)
                                     lunarday_model.append({name:i})

                        }else{
                                    for (var i=1;i<=daystotal;i++)
                                         lunarday_model.append({name:i})

                        }

                        /*if(lunarmonth_model.get(MM-1).nhuan){
                            if(AmLich.LML > lunarday_model.count){
                                for (var i=lunarday_model.count+1;i<=AmLich.LML;i++)
                                     lunarday_model.append({name:i})
                            }else
                                if(AmLich.LML< lunarday_model.count){
                                while(lunarday_model.count>AmLich.LML){
                                     lunarday_model.remove(lunarday_model.count-1);
                                }
                           }

                        }else{
                                if(daystotal > lunarday_model.count){
                                    for (var i=lunarday_model.count+1;i<=daystotal;i++)
                                         lunarday_model.append({name:i})
                                }else
                                    if(daystotal < lunarday_model.count){
                                    while(lunarday_model.count>daystotal){
                                         lunarday_model.remove(lunarday_model.count-1);
                                    }
                               }
                        }*/

                        /*
                        var nhuansetru = 30 - AmLich.LML;

                        if(lunarmonth_model.get(MM-1).nhuan && lunarday_model.count==30){
                            var j=0;
                            while(j<nhuansetru){
                                lunarday_model.remove(lunarday_model.count-1);
                                j++;
                            }
                        }
                        else if(lunarday_model.count<30){
                            for (var i=lunarday_model.count+1;i<=30;i++)
                            lunarday_model.append({name:i})
                        }*/

                        lunarday_rec.index = DD-1;
                        lunarday_pathview.currentIndex= DD-1;

                    }
                }

            /***/


                /**LUNAR MONTH*/
                    Rectangle{
                        state:"switch_to_month"
                        id:lunarmonth_rec
                        x: 60
                        y: -39
                        width: 150; height: 129
                        color:"transparent"

                        property int index: 0
                        onIndexChanged: lunarmonth_pathview.currentIndex = lunarmonth_rec.index

                        Component {
                            id: lunarmonth_delegate
                            Column {
                                id: wrapper

                                Text {
                                    id: nameText
                                    text: name
                                    font.pointSize: 16
                                    width: lunarmonth_rec.width
                                    color: PathView.isCurrentItem ? "#FFFFFF" : "grey"
                                    verticalAlignment:Text.AlignVCenter
                                    font.bold: true
                                }

                            }
                        }

                        PathView {
                            id:lunarmonth_pathview
                            anchors.fill: parent
                            model: lunarmonth_model
                            delegate: lunarmonth_delegate
                             pathItemCount: 1
                             clip: true
                             preferredHighlightBegin: 0.5
                             preferredHighlightEnd: 0.5
                             highlightRangeMode: PathView.StrictlyEnforceRange
                             focus: true
                             path: Path {
                                 startX: 90
                                 startY: 0
                                 PathLine {x: 90; y: lunarmonth_rec.height}
                             }
                             onMovementEnded: {
                                 //console.log(lunaryear_pathview.currentIndex)
                                // console.log(AmLich.LML)

                                lunarday_model.change(lunarmonth_pathview.currentIndex+1,lunarday_pathview.currentIndex+1);
                             }
                        }

                        MouseArea {
                            id:lunarmonth_mousearea
                            anchors.fill: parent
                            onClicked: {
                                amdatetime.state="switch_to_month"
                            }
                        }

                    }

                    ListModel {
                        id:lunarmonth_model

                        Component.onCompleted: {

                        }

                        function change(YYYY, MM){
                            while(lunarmonth_model.count>0){
                                lunarmonth_model.remove(lunarmonth_model.count-1)
                            }
                            readd(YYYY, MM)

                           lunarday_model.change(lunarmonth_pathview.currentIndex+1,lunarday_pathview.currentIndex+1);
                        }

                        function readd(YYYY, MM){
                            var yTest = YYYY;
                            var preFix = "Tháng ";
                            var a=AmLich.leapMonth(yTest)
                            var t=0;
                            if(a){ // nam nhuan
                                 for(var i=0;i<=12;i++){
                                    var l=AmLich.getYearInfo(yTest)[i].month
                                     if (t==l)
                                         lunarmonth_model.append({name:preFix+l+" (N)", nhuan:true})
                                     else
                                         lunarmonth_model.append({name:preFix+l, nhuan:false})
                                     t=l
                                 }

                            }else
                                {
                                for(var i=1;i<=12;i++)
                                    lunarmonth_model.append({name:preFix+i, nhuan:false})
                            }

                            lunarmonth_rec.index = MM -1;
                            lunarmonth_pathview.currentIndex = MM-1;

                        }
                    }

                /***/
        }

    }

    Component.onCompleted: {

    }

    states: [
        State {
            name: "switch_to_day";
            PropertyChanges { target:lmk;x:10;width:60;}
            PropertyChanges { target:lunaryear_pathview;pathItemCount:1;}
                                    PropertyChanges { target:lunarmonth_pathview;pathItemCount:1;}
            PropertyChanges { target:lunarday_pathview;pathItemCount:3;}
            PropertyChanges { target:lunarday_mousearea;visible:false;}
            PropertyChanges { target:lunaryear_mousearea;visible:true;}
            PropertyChanges { target:lunarmonth_mousearea;visible:true;}
        },
        State {
            name: "switch_to_year";
            PropertyChanges { target:lmk;x:207;width:198;}
            PropertyChanges { target:lunarday_pathview;pathItemCount:1;}
                                    PropertyChanges { target:lunarmonth_pathview;pathItemCount:1;}
            PropertyChanges { target:lunaryear_pathview;pathItemCount:3;}
            PropertyChanges { target:lunarday_mousearea;visible:true;}
            PropertyChanges { target:lunaryear_mousearea;visible:false;}
                        PropertyChanges { target:lunarmonth_mousearea;visible:true;}
        },
        State {
            name: "switch_to_month";
            PropertyChanges { target:lmk;x:60;width:150;}
            PropertyChanges { target:lunarday_pathview;pathItemCount:1;}
            PropertyChanges { target:lunaryear_pathview;pathItemCount:1;}
                        PropertyChanges { target:lunarmonth_pathview;pathItemCount:3;}
            PropertyChanges { target:lunarday_mousearea;visible:true;}
            PropertyChanges { target:lunaryear_mousearea;visible:true;}
                        PropertyChanges { target:lunarmonth_mousearea;visible:false;}
        }
    ]

    transitions: [
        Transition { NumberAnimation { properties: "x,y,opacity"; duration: 100; easing.type: Easing.InOutBack } }
    ]

    function reset(){
        var acs = AmLich.getYearInfo(screen.curYear)
        var a=AmLich.getLunarDate(screen.curDay,screen.curMonth,screen.curYear)
                var finalmonth=a.month;
        if (a.leap)
            finalmonth+=1;
        else{
        var aaa=AmLich.leapMonth(screen.curYear)
        var t=-1;

        if (aaa){
           for (var i=0;i<=12;i++){
               var l=acs[i].month
                if (t==l && a.leap==0){
                    if (a.month>i){
                    finalmonth = finalmonth+1;
                    break;
                    }
                }
                t=l
            }

        }
        }

        lunaryear_model.change(a.year)
        lunarmonth_model.change(a.year, finalmonth)
        lunarday_model.change(finalmonth,a.day)

    }
}
