/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/
import QtQuick 1.1

import "Themes.js" as Themes

Item{
    
    id: aboutdlg
    
    anchors.verticalCenter: parent.verticalCenter
    width: parent.width; height: parent.height;
    x:(parent.width * 1.5)

    signal close
    
    Loader {
        id: theme_manager
        property alias theme: theme_manager.item
        source: Themes.default_theme()
        }

    Connections {
        target: aboutdlg.parent
        
        onDialogClose: {
            aboutdlg.state = "close";
            aboutdlg.destroy(600);
            }
        }

    
    Rectangle {
        id: rectangle1
        anchors.fill: parent; anchors.bottomMargin: 0
        visible: true
        opacity:0.8
        
        Image {
            id: image1
            x: 0
            y: 43
            width: 100
            height: 100
            anchors.horizontalCenterOffset: 0
            anchors.horizontalCenter: parent.horizontalCenter
            source: "qrc:/LichViet.png"
            
            Text {
                id: text3
                x: 10
                y: 261
                height: 20
                text: "Chương trình có tham khảo thuật toán tính <br>Âm Lịch của tác giả Hồ Ngọc Đức.<br><a href='http://www.informatik.uni-leipzig.de/~duc/amlich/'>http://www.informatik.uni-leipzig.de/~duc/amlich/</a>"
                anchors.horizontalCenterOffset: 0
                anchors.horizontalCenter: parent.horizontalCenter
                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignHCenter
                font.pixelSize: 16
                }
            }
        
        Text {
            id: text1
            x: 11
            y: 171
            height: 20
            text: "Lịch Âm Việt Nam <br> OS: Maemo 5 (Fremantle)"
            anchors.horizontalCenterOffset: 1
            font.bold: true
            anchors.horizontalCenter: parent.horizontalCenter
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font.pixelSize: 23
            }
        
        Text {
            id: text2
            x: 10
            y: 234
            height: 20
            text: "Phiên bản : 1.0.2-7 (15/09/2011)<br>\
Phát triển bởi : <a href='mailto:metacuong@gmail.com'>metacuong@gmail.com</a>"
            anchors.horizontalCenterOffset: 0
            wrapMode: Text.NoWrap
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            anchors.horizontalCenter: parent.horizontalCenter
            font.pixelSize: 24
            }
        
        
        }

    Rectangle {
        width : aboutdlg.width
        height: 45
        color:"white"
        opacity: 0.5
        }
    
    Text {
        id: title
        
        anchors { horizontalCenter: aboutdlg.horizontalCenter; top: aboutdlg.top; topMargin: 10 }
        font.pixelSize: 22
        color: "black"
        text: qsTr("About")
        smooth: true
        font.bold: true
        }
    
    
    ToolBarSingle {
        id: toolBar; height: 42;
        y: parent.height-52
        width: parent.width;
        button1Label: "Quay Về"
        onButton1Clicked:aboutdlg.close()
        }
    
    states: [
        State {
            name: "show"
            AnchorChanges { target: aboutdlg; anchors.right: parent.right }
            },
        State {
            name: "close"
            AnchorChanges { target: aboutdlg; anchors.right: parent.left }
            }
        ]
    
    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 300 }
        }
    
    }
