/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

.pragma library

/*
  @spec : [day,month,detail]
  */
var DuongLich = new Array(
        [1,1,"Tết Dương lịch"],
        [3,2,"Thành lập ĐCS Việt Nam"],
        [14,2,"Lễ tình nhân (Valentin day)"],
        [27,2,"Ngày thầy thuốc Việt Nam"],
        [8,3,"Quốc tế phụ nữ"],
        [17,3,"Thánh Phatrick"],
        [1,4," Cá tháng tư"],
        [30,4,"Giải phóng miền Nam"],
        [1,5,"Quốc tế lao động"],
        [19,5,"Sinh nhật Bác Hồ"],
        [1,6,"Quốc tế thiếu nhi"],
        [5,6,"Ngày môi trường Thế giới"],
        [28,6," Gia đình Việt Nam"],
        [27,7,"Thương binh liệt sĩ"],
        [1,9,"Ngày lao động"],
        [2,9,"Quốc Khánh<br><span style='font-size:18px;'>Nước CHXH CN Việt Nam</span>"],
        [10,10,"Giải phóng thủ đô (Hà Nội)"],
        [13,10," Ngày doanh nhân Việt Nam"],
        [20,10,"Phụ nữ Việt Nam"],
        [30,10,"Halloween"],
        [11/11,"Cựu chiến binh"],
        [20,11,"Nhà giáo Việt Nam"],
        [22,11,"Thành lập quân đội nhân dân VN"],
        [25,12,"Giáng sinh (Chirstmas day)"]
        );

var AmLich = new Array(
        [1,1,"Tết Nguyên Đán"],
        [15,1,"Lễ Thượng Nguyên"],
        [3,3,"Tết Hàn thực"],
        [10,3,"Giỗ tổ Hùng Vương"],
        [14,4,"Tết dân tộc Khmer (Nam bộ)"],
        [15,4,"Lễ Phật Đản"],
        [5,5,"Tết Đoan Ngọ"],
        [15,7,"Lễ Vu Lan"],
        [1,8,"Tết Katê (dân tộc Chăm)"],
        [15,8,"Tết Trung Thu"],
        [10,10,"Tết Thường Tân"],
        [15,11,"Tết Hạ Nguyên"],
        [23,12,"Lễ Táo Quân lên trời"],
        [30,12,"Giao thừa"]
        );

var Loi_Hay_Y_Dep = new Array(
        "Ái tình giống như rượu mùi,<br>càng ít tỏa hương lại càng nồng.<br><i>(Charles Duclos)</i>",
        "Không phải lập được những kỳ công<br>thì cuộc đời mới tốt đẹp.<br><i>(Herry Bordeaux)<i>",
        "Hãy yêu thương khi còn trẻ,<br>hãy lo cứu tế lúc về già.<br><i>(Stendhal)</i>",
        "Mọi người đều nói đến quyền lợi,<br>không mấy ai nói đến bổn phận.<br><i>(Alfred Mortier)</i>",
        "Con người là nô lệ vì chưa hủy diệt<br>được ý tưởng về bản ngã trong nội tâm.<br><i>(Kinh Phật)</i>",
        "Dù đá có biến thành vàng<br>thì lòng con người vẫn không thỏa mãn.<br><i>(Ngạn ngữ Trung Hoa)</i>",
        "Cuộc sống đơn điệu không có sự cố gắng<br>là cuộc sống vô vị.<br><i>(Amiel)</i>",
        "Bạc kém giá trị hơn vàng,<br>vàng lại kém giá trị hơn đạo đức.<br><i>(Horace)</i>",
        "Bí quyết để sống hạnh phúc<br>là biết chờ đợi hạnh phúc của mình.<br><i>(Rivière)</i>",
        "Đọc sách không bằng suy gẫm.<br>Học trường học không bằng học trường đời.<br><i>(Kant)</i>",
        "Người khôn ngoan<br>là kẻ là cái gì cũng thấy mới lạ.<br><i>(André Gide)</i>",
        "Hãy kiêu hãnh trong khiêm tốn,<br>kiêu hãnh như vậy mới là không kiêu.<br><i>(Burton)</i>",
        "Bạn không cần hòan hảo nhưng bạn phải biết<br>rút kinh nghiệm từ những sai lầm của mình.<br><i>(Mc Cormack)</i>",
        "Nhan sắc chỉ làm vui thỏa đôi mắt,<br>còn nét dịu dàng lại ấm áp cõi lòng.<br><i>(Voltaire)</i>",
        "Chớ bảo điều thiện này nhỏ mà không làm,<br>chớ bảo điều ác kia nhỏ mà cứ làm.<br><i>(Lưu Bị)</i>",
        "Đời không tình yêu như trời không có nắng.<br><i>(Ngạn ngữ Pháp)</i>",
        "Lạc thú ái tình trong chốc lát,<br>muộn phiền lôi kéo mãi trọn đời.<br><i>(Florian)</i>",
        "Nhân từ, ngọt ngào<br>là dấu hiệu của tính cao thượng.<br><i>(Pythagor)</i>",
        "Hãy giữ người bạn chân thành<br>với cả hai tay của bạn.<br><i>(Khuyết Danh)</i>",
        "Đời dù sướng hay khổ cũng vẫn đẹp,<br>hãy chờ đón nó.<br><i>(Fernand Gregh)</i>",
        "Hãy yêu mến lời khuyên can,<br>đừng yêu mếm lời tâng nịnh.<br><i>(Ngạn ngữ Nga)</i>"
        );

function get(curDay, curMonth,lunarDay, lunarMonth) {
    var day_info = "";

    for (var i=0;i<AmLich.length;i++)
        if (AmLich[i][0] == lunarDay && AmLich[i][1] == lunarMonth){
            day_info+=AmLich[i][2];
            break;
         }

    for(i=0;i<DuongLich.length;i++)
        if (DuongLich[i][0] == curDay && DuongLich[i][1] == curMonth){
            if (!day_info)
                day_info=DuongLich[i][2];
            else
                day_info+="<br><span style='font-size:18px;'>("+DuongLich[i][2]+")</span>";
            break;
        }


    if (!day_info){
        var rannum=Math.floor(Math.random()*Loi_Hay_Y_Dep.length)
        day_info =  Loi_Hay_Y_Dep[rannum];
    }

    return  day_info;
}

function is_holiday(day, month, lunar_day, lunar_month){

    if (day === 0 || month === 0)
        return false;

    for(var i=0;i<DuongLich.length;i++)
        if (DuongLich[i][0] == day && DuongLich[i][1] ==month)
            return true;


    for (i=0;i<AmLich.length;i++)
        if (AmLich[i][0] == lunar_day && AmLich[i][1] == lunar_month)
            return true;

    return false;
}
