/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/
import QtQuick 1.1
import "../DatePicker/component" as Comp

import "Themes.js" as Themes
import "main.js" as Script

Item{
    id: datetimedlg

    anchors.verticalCenter: parent.verticalCenter
    width: parent.width; height: parent.height;
    x:(parent.width * 1.5)

    Loader {
        id: theme_manager
        property alias theme: theme_manager.item
        source: Themes.default_theme()
    }

    signal toolbar
    signal updatedate(int day, int month, int year)

    Rectangle {
        id: rectangle1
        x: 0
        y: -16
        anchors.centerIn: parent
        width:344
        height: 234
        color: "#19262b"
        radius: 8
        border.color: "#b57e8f"
        visible: true
        opacity:0.9



        Column {
            id: datePicker
            width: 260
            property int mDay: Script.curDay
            property int mMonth: Script.curMonth
            property int mYear: Script.curYear
            anchors.centerIn: parent

            Comp.DateReel {
                id: dateReel
                width: parent.width
            }}


        Button {
            id: button2
            x: 102
            anchors.right: parent.right; anchors.rightMargin: 102; y: 185; width: 140; height: 40
            text: "OK"
            visible: true
            onClicked: {
                datetimedlg.state="close";
                datetimedlg.toolbar();
                datetimedlg.updatedate(datePicker.mDay, datePicker.mMonth, datePicker.mYear)

                }
        }

        Button {
            id: button3
            x: 298
            y: 6
            width: 39
            height: 40
            text: "X"
            anchors.rightMargin: 56
            onClicked: {
                datetimedlg.state="close";
                datetimedlg.toolbar();
            }
        }
    }

    function reset(){
        dateReel.day_reset()
                dateReel.month_reset()
                dateReel.year_reset()
    }

    states: [
        State {
            name: "show"
            AnchorChanges { target: datetimedlg; anchors.right: parent.right }
        },
        State {
            name: "close"
            AnchorChanges { target: datetimedlg; anchors.right: parent.left }
        }
    ]

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 300 }
    }

}
